@extends('vendor.installer.layouts.master')

@section('template_title')
    {{ trans('installer_messages.environment.wizard.templateTitle') }}
@endsection

@section('title')
    <i class="ti ti-stars" aria-hidden="true"></i>
    {!! trans('installer_messages.environment.wizard.title') !!}
@endsection

@section('container')
    <div class="tabs tabs-full">
        <form method="post" action="{{ route('LaravelInstaller::environmentSaveWizard') }}">
            <label for="tab1" class="tab-label">
                <i class="ti ti-world fa-2x fa-fw" aria-hidden="true"></i>
                <br />
                {{ trans('installer_messages.environment.wizard.tabs.environment') }}
            </label>
            <div id="tab1content">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <div class="form-group {{ $errors->has('app_name') ? ' has-error ' : '' }}">
                    <label for="app_name">
                        {{ trans('installer_messages.environment.wizard.form.app_name_label') }}
                    </label>
                    <input type="text" name="app_name" id="app_name" value=""
                        placeholder="{{ trans('installer_messages.environment.wizard.form.app_name_placeholder') }}" />
                    @if ($errors->has('app_name'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('app_name') }}
                        </span>
                    @endif
                </div>

                <input type="hidden" name="environment" value="local" />
                <input type="hidden" name="app_debug" value="false" />
                <input type="hidden" name="app_log_level" value="debug" />
                <div class="form-group {{ $errors->has('app_url') ? ' has-error ' : '' }}">
                    <label for="app_url">
                        {{ trans('installer_messages.environment.wizard.form.app_url_label') }}
                    </label>
                    <input type="url" name="app_url" id="app_url" value="http://localhost"
                        placeholder="{{ trans('installer_messages.environment.wizard.form.app_url_placeholder') }}" />
                    @if ($errors->has('app_url'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('app_url') }}
                        </span>
                    @endif
                </div>
            </div>

            <label for="tab2" class="tab-label">
                <i class="ti ti-database fa-2x fa-fw" aria-hidden="true"></i>
                <br />
                {{ trans('installer_messages.environment.wizard.tabs.database') }}
            </label>
            <div id="tab2content">

                <input type="hidden" name="database_connection" value="mysql" />
                <div class="form-group {{ $errors->has('database_connection') ? ' has-error ' : '' }}">
                    <label for="database_connection">
                        {{ trans('installer_messages.environment.wizard.form.db_connection_label') }}
                    </label>
                    <b>{{ trans('installer_messages.environment.wizard.form.db_connection_label_mysql') }}</b>
                    <br><br>
                </div>

                <div class="form-group {{ $errors->has('database_hostname') ? ' has-error ' : '' }}">
                    <label for="database_hostname">
                        {{ trans('installer_messages.environment.wizard.form.db_host_label') }}
                    </label>
                    <input type="text" name="database_hostname" id="database_hostname" value="127.0.0.1"
                        placeholder="{{ trans('installer_messages.environment.wizard.form.db_host_placeholder') }}" />
                    @if ($errors->has('database_hostname'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('database_hostname') }}
                        </span>
                    @endif
                </div>

                <div class="form-group {{ $errors->has('database_port') ? ' has-error ' : '' }}">
                    <label for="database_port">
                        {{ trans('installer_messages.environment.wizard.form.db_port_label') }}
                    </label>
                    <input type="number" name="database_port" id="database_port" value="3306"
                        placeholder="{{ trans('installer_messages.environment.wizard.form.db_port_placeholder') }}" />
                    @if ($errors->has('database_port'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('database_port') }}
                        </span>
                    @endif
                </div>

                <div class="form-group {{ $errors->has('database_name') ? ' has-error ' : '' }}">
                    <label for="database_name">
                        {{ trans('installer_messages.environment.wizard.form.db_name_label') }}
                    </label>
                    <input type="text" name="database_name" id="database_name" value=""
                        placeholder="{{ trans('installer_messages.environment.wizard.form.db_name_placeholder') }}" />
                    @if ($errors->has('database_name'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('database_name') }}
                        </span>
                    @endif
                </div>

                <div class="form-group {{ $errors->has('database_username') ? ' has-error ' : '' }}">
                    <label for="database_username">
                        {{ trans('installer_messages.environment.wizard.form.db_username_label') }}
                    </label>
                    <input type="text" name="database_username" id="database_username" value=""
                        placeholder="{{ trans('installer_messages.environment.wizard.form.db_username_placeholder') }}" />
                    @if ($errors->has('database_username'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('database_username') }}
                        </span>
                    @endif
                </div>

                <div class="form-group {{ $errors->has('database_password') ? ' has-error ' : '' }}">
                    <label for="database_password">
                        {{ trans('installer_messages.environment.wizard.form.db_password_label') }}
                    </label>
                    <input type="password" name="database_password" id="database_password" value=""
                        placeholder="{{ trans('installer_messages.environment.wizard.form.db_password_placeholder') }}" />
                    @if ($errors->has('database_password'))
                        <span class="error-block">
                            <i class="ti ti-alert-triangle" aria-hidden="true"></i>
                            {{ $errors->first('database_password') }}
                        </span>
                    @endif
                </div>
            </div>
            <div id="tab3content">

                <input type="hidden" name="app_maintenance_driver" value="file" />
                <input type="hidden" name="bcrypt_rounds" value="12" />
                <input type="hidden" name="log_channel" value="stack" />
                <input type="hidden" name="log_stack" value="single" />
                <input type="hidden" name="broadcast_driver" value="log" />
                <input type="hidden" name="cache_driver" value="file" />
                <input type="hidden" name="session_driver" value="file" />
                <input type="hidden" name="session_encrypt" value="false" />
                <input type="hidden" name="broadcast_connection" value="log" />
                <input type="hidden" name="filesystem_disk" value="local" />
                <input type="hidden" name="queue_connection" value="database" />
                <input type="hidden" name="cache_store" value="file" />
                <input type="hidden" name="queue_driver" value="sync" />
                <input type="hidden" name="redis_hostname" value="127.0.0.1" />
                <input type="hidden" name="redis_password" value="null" />
                <input type="hidden" name="redis_port" value="6379" />
                <input type="hidden" name="mail_driver" value="smtp" />
                <input type="hidden" name="mail_host" value="smtp.mailtrap.io" />
                <input type="hidden" name="mail_port" value="2525" />
                <input type="hidden" name="mail_username" value="null" />
                <input type="hidden" name="mail_password" value="null" />
                <input type="hidden" name="mail_encryption" value="null" />
                <input type="hidden" name="pusher_app_id" value="" />
                <input type="hidden" name="pusher_app_key" value="" />
                <input type="hidden" name="pusher_app_secret" value="" />

                <div class="buttons">
                    <button class="button" type="submit">
                        {{ trans('installer_messages.environment.wizard.form.buttons.install') }}
                        <i class="ti ti-chevron-right fa-fw" aria-hidden="true"></i>
                    </button>
                </div>
            </div>
        </form>

    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        function checkEnvironment(val) {
            var element = document.getElementById('environment_text_input');
            if (val == 'other') {
                element.style.display = 'block';
            } else {
                element.style.display = 'none';
            }
        }

        function showDatabaseSettings() {
            document.getElementById('tab2').checked = true;
        }

        function showApplicationSettings() {
            document.getElementById('tab3').checked = true;
        }
    </script>
@endsection
