<span>
    @can('impersonate-user')
        <a class="btn btn-secondary btn-sm" href="{{ route('users.impersonate', $user->id) }}" data-bs-toggle="tooltip"
            data-bs-placement="bottom" data-bs-original-title="{{ __('Impersonate') }}" aria-label="{{ __('Impersonate') }}">
            <i class="ti ti-new-section"></i>
        </a>
    @endcan
    @can('phoneverified-user')
        <a class="btn btn-{{ $user->phone_verified_at ? 'info' : 'warning' }} btn-sm"
            href="{{ route('user.phoneverified', $user->id) }}" data-bs-toggle="tooltip" data-bs-placement="bottom"
            data-bs-original-title="{{ $user->phone_verified_at ? __('Phone Verified') : __('Phone Unverified') }}">
            <i class="ti ti-message-circle"></i>
        </a>
    @endcan
    @can('emailverified-user')
        <a class="btn btn-{{ $user->email_verified_at ? 'info' : 'warning' }} btn-sm"
            href="{{ route('user.verified', $user->id) }}" data-bs-toggle="tooltip" data-bs-placement="bottom"
            data-bs-original-title="{{ $user->email_verified_at ? __('Email Verified') : __('Email Unverified') }}">
            <i class="ti ti-{{ $user->email_verified_at ? 'mail' : 'mail-forward' }}"></i>
        </a>
    @endcan
    @can('edit-user')
        <a class="btn btn-primary btn-sm" href="javascript:void(0);" id="edit-user"
            data-url="{{ route('users.edit', $user->id) }}" data-bs-toggle="tooltip" data-bs-placement="bottom"
            data-bs-original-title="{{ __('Edit') }}"><i class="ti ti-edit"></i></a>
    @endcan
    @can('delete-user')
        {!! html()->form('DELETE', route('users.destroy', $user->id))->id('delete-form-' . $user->id)->class('d-inline')->open() !!}
        <a href="javascript:void(0)" class="btn btn-danger btn-sm show_confirm" id="delete-form-{{ $user->id }}"
            data-bs-toggle="tooltip" data-bs-placement="bottom" data-bs-original-title="{{ __('Delete') }}"><i
                class="ti ti-trash"></i></a>
        {!! html()->form()->close() !!}
    @endcan
</span>
