@php
    $hashids = new Hashids('', 20);
    $id = $hashids->encodeHex($poll->id);
    use Carbon\Carbon;
@endphp
@extends('layouts.main')
@section('title', __('Vote'))
@section('breadcrumb')
    <div class="col-md-12">
        <div class="page-header-title">
            <h4 class="m-b-10">{{ __('Vote') }}</h4>
        </div>
        <ul class="breadcrumb">
            <li class="breadcrumb-item">{!! html()->a(route('home'), __('Dashboard')) !!}</li>
            <li class="breadcrumb-item">{!! html()->a(route('poll.index'), __('Polls')) !!}</li>
            <li class="breadcrumb-item active"> {{ __('Vote') }} </li>
        </ul>
    </div>
@endsection
@section('content')
    <div class="row">
        {!! html()->modelForm($poll, 'POST', route('meeting.poll.store', $poll->id))->attribute('data-validate')->attribute('class', 'form-horizontal')->open() !!}
        <div class="row">
            <div class="mx-auto col-xl-7 order-xl-1">
                <div class="card">
                    <div class="card-header">
                        <h5>{{ __('Vote') }}</h5>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-0">{{ $poll->title }}</h3>
                        <span class="text-left">
                            <small>{{ $poll->created_at->diffForHumans() }}</small>
                        </span>
                        @if ($poll->meeting_fixed_time_zone == 1)
                            <div class="from-group">
                                <label class="col-3 col-form-label"><i
                                        class="ti ti-world "></i>{{ __('Time zone:') }}{{ $poll->meetings_fixed_time_zone }}</label>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-3 col-form-label">{{ __('Make a choice:') }}</label>
                            @foreach ($options->meeting_answer_options as $key => $option)
                                <div class="form-group">
                                    <div class="mb-3 input-group vote-metting">
                                        <div class="input-group-text">
                                            <input class="form-check-input" name="meeting_answer_options[]" type="checkbox"
                                                value="{{ $option->datetime }}"
                                                aria-label="Checkbox for following text input">
                                        </div>
                                        <label class="form-control" readonly>
                                            {{ Utility::date_time_format($option->datetime) }}
                                        </label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <hr>
                        <div class="form-group">
                            {!! html()->label(__('Name'), 'name')->class('form-label') !!}
                            {!! html()->text('name')->class('form-control')->required()->placeholder(__('Enter Name')) !!}
                        </div>
                        @if ($poll->meeting_set_end_date == 1)
                            <h6>{{ __('Voting ends in') }}
                                {{ Carbon::parse($poll->meeting_set_end_date_time)->diffForHumans() }}</h6>
                        @endif
                    </div>
                    <div class="card-footer">
                        <div class="text-end">
                            {!! html()->button(__('Vote'))->type('submit')->class('btn btn-primary col-md-3') !!}
                            <a href="{{ route('poll.meeting.result', $poll->id) }}" class="btn btn-success"><i
                                    class="me-2" data-feather="award"></i>{{ __('Result') }}</a>
                            <a class="btn btn-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="share"
                                href="javascript:void(0);" id="share-poll"
                                data-action="{{ route('poll.shares.meetings', $poll->id) }}"><i class="me-2"
                                    data-feather="share-2"></i>{{ __('Share') }}</a>
                        </div>
                    </div>
                </div>
                {!! html()->closeModelForm() !!}
            </div>
        </div>
    </div>
    <div class="row">
        <div class="mx-auto col-xl-7 order-xl-1">
            <div class="card">
                <div class="card-header">
                    <h5> <i class="me-2" data-feather="share-2"></i>{{ __('Share') }}</h5>
                </div>
                <div class="card-body ">
                    <div class="m-auto form-group col-6">
                        <p>{{ __('Use this link to share the poll with your participants.') }}</p>
                        <div class="input-group">
                            <input type="text" value="{{ route('poll.survey.meeting', $id) }}"
                                class="form-control js-content" id="pc-clipboard-1" placeholder="Type some value to copy">
                            <a href="javascript:void(0)" class="btn btn-primary js-copy" data-clipboard="true"
                                data-clipboard-target="#pc-clipboard-1"> {{ __('Copy') }}
                            </a>
                        </div>
                        <div class="mt-3 social-links-share">
                            <a href="https://api.whatsapp.com/send?text={{ route('poll.survey.meeting', $id) }}"
                                title="Whatsapp" class="social-links-share-main">
                                <i class="ti ti-brand-whatsapp"></i>
                            </a>
                            <a href="https://twitter.com/intent/tweet?text={{ route('poll.survey.meeting', $id) }}"
                                title="Twitter" class="social-links-share-main">
                                <i class="ti ti-brand-twitter"></i>
                            </a>
                            <a href="https://www.facebook.com/share.php?u={{ route('poll.survey.meeting', $id) }}"
                                title="Facebook" class="social-links-share-main">
                                <i class="ti ti-brand-facebook"></i>
                            </a>
                            <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ route('poll.survey.meeting', $id) }}"
                                title="Linkedin" class="social-links-share-main">
                                <i class="ti ti-brand-linkedin"></i>
                            </a>

                            <a href="javascript:void(1);" class="social-links-share-main" title="Show QR Code"
                                data-action="{{ route('poll.share.qr.meeting', $id) }}" id="share-qr">
                                <i class="ti ti-qrcode"></i>
                            </a>
                            <a href="javascript:void(0)" title="Embed" class="social-links-share-main"
                                onclick="copyToClipboard('#embed-form-{{ $poll->id }}')"
                                id="embed-form-{{ $poll->id }}"
                                data-url='<iframe src="{{ route('poll.survey.meeting', $id) }}" scrolling="auto" align="bottom" height=100vh" width="100%"></iframe>'>
                                <i class="ti ti-code"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @if ($poll->meeting_allow_comments == 1)
        <div class="row">
            <div class="mx-auto col-xl-7 order-xl-1">
                <div class="card">
                    <div class="card-header">
                        <h5> <i class="me-2" data-feather="message-circle"></i>{{ __('Comments') }}</h5>
                    </div>
                    {!! html()->form('POST', route('comment.store'))->attribute('data-validate')->open() !!}
                    <div class="card-body">
                        <div class="form-group">
                            {!! html()->text('name')->class('form-control')->required()->placeholder(__('Enter your name')) !!}
                        </div>
                        <div class="form-group">
                            {!! html()->textarea('comment')->class('form-control')->rows(3)->required()->placeholder(__('Add a comment')) !!}
                        </div>
                    </div>
                    <input type="hidden" id="poll_id" name="poll_id" value="{{ $poll->id }}">
                    <div class="card-footer">
                        <div class="text-end">
                            {!! html()->button(__('Add a comment'))->type('submit')->class('btn btn-primary col-md-3') !!}
                        </div>
                        {!! html()->form()->close() !!}
                        @foreach ($poll->commmant as $value)
                            <div class="comments-item">
                                <div class="comment-user-icon">
                                    <img src="{{ asset('assets/images/comment.png') }}" alt="">
                                </div>
                                <span class="text-left comment-info">
                                    <h6>{{ $value->name }}</h6>
                                    <span class="d-block"><small>{{ $value->comment }}</small></span>
                                    <h6 class="d-block"><small>({{ $value->created_at->diffForHumans() }})</small>
                                        <a href="#reply-comment" class="text-dark reply-comment-{{ $value->id }}"
                                            id="comment-reply" data-bs-toggle="collapse" data-id="{{ $value->id }}"
                                            title="{{ __('Reply') }}">
                                            {{ __('Reply') }}</i></a>
                                        {!! html()->form('DELETE', route('comment.destroy', $value->id))->id('delete-form-' . $value->id)->class('d-inline')->open() !!}
                                        <a href="javascript:void(0)" class="text-dark show_confirm" title="Delete"
                                            id="delete-form-{{ $value->id }}">{{ __('Delete') }}</a>

                                        {!! html()->form()->close() !!}
                                    </h6>
                                    <li class="list-inline-item"> </li>
                                    @foreach ($value->replyby as $replyValue)
                                        <div class="comment-replies">
                                            <div class="comment-user-icon">
                                                <img src="{{ asset('assets/images/comment.png') }}" alt="">
                                            </div>
                                            <div class="comment-replies-content">
                                                <h6>{{ $replyValue->name }}</h6>
                                                <span class="d-block"><small>{{ $replyValue->reply }}</small></span>
                                                <h6 class="d-block">
                                                    <small>({{ $replyValue->created_at->diffForHumans() }})</small>
                                            </div>
                                        </div>
                                    @endforeach
                                </span>
                            </div>
                            {!! html()->form('POST', route('comment.reply.store'))->attribute('data-validate')->open() !!}
                            <div class="row commant" id="reply-comment-{{ $value->id }}">
                                <div class="form-group">
                                    {!! html()->text('name')->class('form-control')->required()->placeholder(__('Enter your name')) !!}
                                </div>
                                <div class="form-group">
                                    {!! html()->textarea('reply')->class('form-control')->rows(2)->required()->placeholder(__('Add a comment')) !!}
                                </div>
                                <input type="hidden" id="poll_id" name="poll_id" value="{{ $poll->id }}">
                                <input type="hidden" id="comment_id" name="comment_id" value="{{ $value->id }}">
                                <div class="card-footer">
                                    <div class="text-end">
                                        {!! html()->button(__('Add a Reply'))->type('submit')->class('btn btn-primary col-md-3') !!}
                                    </div>
                                </div>
                            </div>
                            {!! html()->form()->close() !!}
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
@push('script')
    <script src="{{ asset('assets/js/plugins/clipboard.min.js') }}"></script>
    <script>
        new ClipboardJS('[data-clipboard=true]').on('success', function(e) {
            e.clearSelection();
        });
    </script>
    <script>
        $(function() {
            $(document).on('click', '#share-poll', function() {
                var action = $(this).data('action');
                var modal = $('#common_modal1');
                $.get(action, function(response) {
                    modal.find('.modal-title').html('{{ __('Share') }}');
                    modal.find('.modal-body').html(response.html);
                    feather.replace();
                    let area = document.createElement('textarea');
                    document.body.appendChild(area);
                    area.style.display = "none";
                    let content = document.querySelectorAll('.js-content');
                    let copy = document.querySelectorAll('.js-copy');
                    for (let i = 0; i < copy.length; i++) {
                        copy[i].addEventListener('click', function() {
                            area.style.display = "block";
                            area.value = content[i].innerText;
                            area.select();
                            document.execCommand('copy');
                            area.style.display = "none";
                            this.innerHTML = 'Copied ';
                            setTimeout(() => this.innerHTML = "Copy", 2000);
                        });
                    }
                    modal.modal('show');
                })
            });
        });
    </script>
    <script>
        $(function() {
            $(document).on('click', '#share-qr', function() {
                var action = $(this).data('action');
                var modal = $('#common_modal2');
                $.get(action, function(response) {
                    modal.find('.modal-title').html('{{ __('QR Code') }}');
                    modal.find('.modal-body').html(response.html);
                    feather.replace();
                    modal.modal('show');
                })
            });
        });
    </script>
    <script>
        function copyToClipboard(element) {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(element).data('url')).select();
            document.execCommand("copy");
            $temp.remove();
            show_toastr('Great!', '{{ __('Copy Link Successfully.') }}', 'success');
        }
    </script>
    <script>
        $(document).ready(function() {
            $('.commant').hide();
            $(document).on('click', '#comment-reply', function() {
                var dataId = $(this).attr("data-id");
                $('#reply-comment-' + dataId).show();

            });
        });
    </script>
    <script>
        (function() {
            let area = document.createElement('textarea');
            document.body.appendChild(area);
            area.style.display = "none";
            let content = document.querySelectorAll('.js-content');
            let copy = document.querySelectorAll('.js-copy');
            for (let i = 0; i < copy.length; i++) {
                copy[i].addEventListener('click', function() {
                    area.style.display = "block";
                    area.value = content[i].innerText;
                    area.select();
                    document.execCommand('copy');
                    area.style.display = "none";
                    this.innerHTML = 'Copied ';
                    setTimeout(() => this.innerHTML = "Copy", 2000);
                });
            }
        })();
    </script>
@endpush
