@extends('layouts.main')
@section('title', __('Landing Page'))
@section('breadcrumb')
    <div class="col-md-12">
        <div class="page-header-title">
            <h4 class="m-b-10">{{ __('Page Settings') }}</h4>
        </div>
        <ul class="breadcrumb">
            <li class="breadcrumb-item">{!! html()->a(route('home'))->text(__('Dashboard')) !!}</li>
            <li class="breadcrumb-item">{{ __('Edit Page') }}</li>
        </ul>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="mx-auto col-xl-7 col-lg-7">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="card">
                            <div class="tab-pane fade show active" id="apps-setting" role="tabpanel"
                                aria-labelledby="landing-apps-setting">
                                {!! html()->modelForm($pageSettings, 'PATCH', route('page-setting.update', $pageSettings->id))->id('froentend-form')->open() !!}
                                @method('put')
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-8 d-flex align-items-center">
                                            <h5 class="mb-0">{{ __('Page Setting') }}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                {!! html()->label(__('Page Title'))->for('page_title')->class('form-label') !!} *
                                                {!! html()->text('page_title', $pageSettings->title)->class('form-control')->placeholder('Enter Page Title')->id('page_title') !!}

                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                {!! html()->label(__('Select Type'))->for('type')->class('form-label') !!}
                                                {!! html()->select(
                                                        'type',
                                                        [
                                                            'link' => 'Link',
                                                            'desc' => 'Descrtiption',
                                                        ],
                                                        $pageSettings->type,
                                                    )->class('form-select')->attribute('data-trigger', true)->id('type') !!}
                                            </div>
                                        </div>
                                        <div class="col-md-12  {{ $pageSettings->type == 'link' ? 'block' : 'd-none' }}"
                                            id="link">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {!! html()->label(__('Link Type'))->for('url_type')->class('form-label') !!}
                                                    {!! html()->select(
                                                            'url_type',
                                                            [
                                                                'ifream' => 'ifream',
                                                                'internal link' => 'Internal Link',
                                                                'external link' => 'External Link',
                                                            ],
                                                            $pageSettings->url_type,
                                                        )->class('form-select')->attribute('data-trigger', true)->id('link') !!}
                                                </div>
                                            </div>
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    {!! html()->label(__('Page URL'))->for('page_url')->class('form-label') !!}
                                                    {!! html()->text('page_url', $pageSettings->page_url)->class('form-control')->placeholder(__('Enter Link URL')) !!}
                                                    <small class="text-muted"><b>{{ __('Simple Page') }}</b> :-
                                                        {{ __('Leave it Blank') }}</small><br>
                                                    <small class="text-muted"><b>{{ __('Internal Link') }}</b> :-
                                                        {{ __('http://localhost/Prime-Laravel-Form-Builder/main_file/') }}</small><br>
                                                    <small class="text-muted"><b>{{ __('External Link') }}</b> :-
                                                        {{ __('http://google.com/') }}</small>
                                                </div>
                                            </div>
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    {!! html()->label(__('Search Friendly URL'))->for('friendly_url')->class('form-label') !!}
                                                    {!! html()->text('friendly_url', $pageSettings->friendly_url)->class('form-control')->placeholder(__('Enter Search Friendly URL')) !!}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12 {{ $pageSettings->type == 'desc' ? 'block' : 'd-none' }}" id="description-content">
                                            <div class="form-group">
                                                {!! html()->label(__('Footer Sub menu Detail'))->for('description')->class('form-label') !!}
                                                {!! html()->textarea('description', $pageSettings->description)->class('form-control')->rows(1)->placeholder(__('Enter Sub Menu detail')) !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-end">
                                        <a href="{{ route('page-setting.index') }}"
                                            class="btn btn-secondary">{{ __('Cancel') }}</a>
                                        {!! html()->button(__('Save'))->type('submit')->id('save-btn')->class('btn btn-primary') !!}
                                    </div>
                                </div>
                                {!! html()->form()->close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>
    <script src="{{ asset('vendor/ckeditor/ckeditor.js') }}"></script>

    <script>
        CKEDITOR.replace('description', {
            filebrowserUploadUrl: "{{ route('ckeditor.upload', ['_token' => csrf_token()]) }}",
            filebrowserUploadMethod: 'form'
        });
        document.addEventListener('DOMContentLoaded', function() {
            var genericExamples = document.querySelectorAll('[data-trigger]');
            for (i = 0; i < genericExamples.length; ++i) {
                var element = genericExamples[i];
                new Choices(element, {
                    placeholderValue: 'This is a placeholder set in the config',
                    searchPlaceholderValue: 'This is a search placeholder',
                });
            }
        });
        $("select[name='type']").change(function() {
            $('#link').hide();
            $('#description-content').hide();
            var test = $(this).val();
            if (test == 'link') {
                $('#description-content').hide();
                $('#link').show();
                $("#link").fadeIn(500);
                $("#link").removeClass('d-none');
                $('#description-content').fadeOut(500);
            } else {
                $('#link').hide();
                $('#description-content').show();
                $("#link").fadeOut(500);
                $("#description-content").fadeIn(500);
                $("#description-content").removeClass('d-none');
            }
        });
    </script>
@endpush
