@push('style')
    <link rel="stylesheet" href="{{ asset('assets/css/plugins/dropzone.min.css') }}">
@endpush
@push('script')
    <script src="{{ asset('assets/js/plugins/dropzone-amd-module.min.js') }}"></script>
    <script>
        Dropzone.autoDiscover = false;
        $(document).ready(function() {
            var totaldropzone = $('.dropzone').map((_, el) => el.id).get();
            totaldropzone.forEach(function(val) {
                if (Dropzone.instances) {
                    Dropzone.instances.forEach(function(instance) {
                        if (instance.element.id === val) {
                            instance.destroy();
                        }
                    });
                }
                var element = document.querySelector("[name='" + val + "']");
                var isMultiple = element.getAttribute('multiple') === 'true';
                var fileExtention = $(document.getElementById(val)).data('extention');
                var acceptedFiles = "";

                if (fileExtention === 'pdf') {
                    acceptedFiles = ".pdf, .pdfa, .fdf, .xdp, .xfa, .pdx, .pdp, .pdfxml, .pdxox";
                } else if (fileExtention === 'image') {
                    acceptedFiles = ".jpeg, .jpg, .png";
                } else if (fileExtention === 'excel') {
                    acceptedFiles = ".xlsx, .csv, .xlsm, .xltx, .xlsb, .xltm, .xlw";
                }

                var myDropzone = new Dropzone(document.getElementById(val), {
                    url: "{{ route('dropzone.upload', $form->id) }}",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    params: {
                        file_extention: fileExtention,
                    },
                    removedfile: function(file) {
                        var fileRef;
                        return (fileRef = file.previewElement) != null ?
                            fileRef.parentNode.removeChild(file.previewElement) : void 0;
                    },
                    acceptedFiles: acceptedFiles,
                    maxFiles: isMultiple ? 10 : 1,
                    parallelUploads: isMultiple ? 10 : 1,
                    addRemoveLinks: true,
                    uploadMultiple: isMultiple,
                    autoProcessQueue: true,
                    init: function() {
                        this.on('success', function(file, response) {
                            if (response.filename && Array.isArray(response.filename)) {
                                var inputField = $('.' + val);
                                var oldValue = inputField.val();
                                var existingFiles = oldValue ? oldValue.split(',') : [];
                                var newFiles = response.filename;
                                var allFiles = Array.from(new Set([...existingFiles, ...
                                    newFiles
                                ]));
                                inputField.val(allFiles.join(','));
                            }

                            if (response.success) {
                                show_toastr('Done!', response.success, 'success');
                            } else {
                                this.removeFile(file);
                                show_toastr('Error!', response.errors, 'danger');
                            }
                        });
                    }
                });
            });
        });
    </script>
@endpush
