@php
    use App\Facades\UtilityFacades;
@endphp
@extends('layouts.main')
@section('title', __('Form Fill'))
@section('breadcrumb')
    <div class="col-md-12">
        <div class="page-header-title">
            <h4 class="m-b-10">{{ __('Form Fill') }}</h4>
        </div>
        <ul class="breadcrumb">
            <li class="breadcrumb-item">{!! html()->a(route('home'), __('Dashboard')) !!}</li>
            <li class="breadcrumb-item">{!! html()->a(route('forms.index'), __('Forms')) !!}</li>
            <li class="breadcrumb-item active">{{ __('Form Fill') }}</li>
        </ul>
    </div>
@endsection
@section('content')
    <div class="loading">{{ __('Loading…') }}</div>
    @include('form.multi-form')
@endsection
@push('style')
    <link rel="stylesheet" type="text/css" href="{{ asset('vendor/jqueryform/css/demo.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/css/signature_pad.css') }}">
    <link href="{{ asset('vendor/jqueryform/css/jquery.rateyo.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('vendor/formTheme/form.css') }}">
    <style>
        .section-body.newform-2 {
            background-image: url({{ Storage::url($form->theme_background_image) }});
        }

        .tab {
            display: none;
        }

        #prevBtn {
            background-color: #bbbbbb;
        }

        .step {
            height: 15px;
            width: 15px;
            margin: 0 2px;
            background-color: #bbbbbb;
            border: none;
            border-radius: 50%;
            display: inline-block;
            opacity: 0.5;
        }

        .step.active {
            opacity: 1;
        }

        .step.finish {
            background-color: #394EEA;
        }
    </style>
@endpush
@push('script')
    <script src="{{ asset('vendor/jqueryform/js/jquery.rateyo.min.js') }}"></script>
    <script src="{{ asset('vendor/js/jquery.payment.min.js') }}"></script>
    <script src="{{ asset('vendor/select2/js/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>

    @if ($form->payment_status == 1)
        @if ($form->payment_type == 'razorpay')
            <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
        @elseif($form->payment_type == 'paypal')
        @if (Utility::getsettings('PAYPAL_SANDBOX_CLIENT_ID'))
            <script src="https://www.paypal.com/sdk/js?client-id={{ Utility::getsettings('PAYPAL_SANDBOX_CLIENT_ID') }}&currency={{ $form->currency_name ?? 'USD' }}"></script>
        @endif
        @elseif($form->payment_type == 'flutterwave')
            <script src="https://checkout.flutterwave.com/v3.js"></script>
        @elseif($form->payment_type == 'paystack')
            <script src="https://js.paystack.co/v1/inline.js"></script>
        @elseif($form->payment_type == 'paytm')
            @if (Utility::getsettings('PAYTM_MERCHANT_ID'))
                <script type="application/javascript" crossorigin="anonymous" src="https://{{ Utility::getsettings('PAYTM_ENVIRONMENT') == 'production' ? 'securegw.paytm.in': 'securegw-stage.paytm.in' }}/merchantpgpui/checkoutjs/merchants/{{ Utility::getsettings('PAYTM_MERCHANT_ID') }}.js"
                data-merchant-id="{{ Utility::getsettings('PAYTM_MERCHANT_ID') }}"></script>
            @endif
        @endif
    @endif

    <script>
        var stripe, card;
        window.addEventListener("load", function() {
            var loader = document.querySelector(".loading");
            $(loader).addClass('d-none');
        });
        $(document).ready(function() {
            var theme = '{{ $form->theme }}';
            var themeColor =
                '{{ $form->color_flag == 'true' ? 'custom-color' : ($form->theme_color ? $form->theme_color : 'theme-2') }}';
            $(document).removeClass();
            $(document).addClass(themeColor);
            @if ($form->color_flag == 'true')
                document.documentElement.style.setProperty('--color-customColor',
                    '{{ $form->theme_color }}');
            @endif
            const sectionBody = $('.section-body');
            switch (theme) {
                case 'theme2':
                    sectionBody.addClass('newform-1');
                    break;
                case 'theme3':
                    sectionBody.addClass('newform-2');
                    break;
                case 'theme4':
                    sectionBody.addClass('newform-3');
                    break;
                case 'theme5':
                    sectionBody.addClass('newform-3 circle');
                    break;
                case 'theme6':
                    sectionBody.addClass('newform-3 circle-custom');
                    break;
                case 'theme7':
                    sectionBody.addClass('newform-1 newform-4');
                    break;
                case 'theme8':
                    sectionBody.addClass('newform-5');
                    break;
            }
            setTimeout(function() {
                $("#setData").trigger('click');
            }, 30);
            @if ($form->payment_status == 1)
                @if ($form->payment_type == 'stripe')
                    stripe = Stripe("{{ UtilityFacades::getsettings('stripe_key') }}");
                    var elements = stripe.elements();
                    var style = {
                        base: {
                            color: '#32325d',
                            lineHeight: '24px',
                            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                            fontSmoothing: 'antialiased',
                            fontSize: '18px',
                            '::placeholder': {
                                color: '#aab7c4'
                            }
                        },
                        invalid: {
                            color: '#fa755a',
                            iconColor: '#fa755a'
                        }
                    };
                    card = elements.create('card', {
                        style: style
                    });
                    card.mount('#card-element');
                    card.addEventListener('change', function(event) {
                        var displayError = document.getElementById('card-errors');
                        if (event.error) {
                            displayError.textContent = event.error.message;
                        } else {
                            displayError.textContent = '';
                        }
                    });
                @endif
                @if ($form->payment_type == 'paypal')
                    var amount   = '{{ $form->amount }}';
                    var name     = '{{ $form->title }}';
                    var currency = '{{ $form->currency_name }}';
                    var form_id  = '{{ $form->id }}';
                    paypal.Buttons({
                        createOrder: function(data, actions) {
                            return actions.order.create({
                                purchase_units: [{
                                    amount: {
                                        value: amount,
                                        currency_code: currency
                                    },
                                    description: name
                                }]
                            });
                        },
                        onApprove: function(data, actions) {
                            return actions.order.capture().then(function(orderData) {
                                var transaction = orderData.purchase_units[0].payments.captures[0];
                                $('#payment_id').val(transaction.id);
                                var errorElement = document.getElementById('paypal-errors');
                                errorElement.textContent = '';
                                $('#paypal-button-container').html('');
                            });
                        },
                        onError: function(err) {
                            $('#nextBtn').removeAttr('disabled').html('Submit');
                            show_toastr('Error!', 'Payment failed: ' + err.message, 'danger');
                        },
                        onCancel: function(data) {
                            $('#nextBtn').removeAttr('disabled').html('Submit');
                            show_toastr('Error!', 'Payment was canceled', 'danger');
                        }
                    }).render('#paypal-button-container');
                @endif
            @endif

            var formValueId = $('#form_value_id').val();
            var SITEURL = '{{ URL::to('') }}';
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            // ('restrictNumeric');
            // $('.cc-number').payment('formatCardNumber');
            // $('.cc-exp').payment('formatCardExpiry');
            // $('.cc-cvc').payment('formatCardCVC');
            $.fn.toggleInputError = function(erred) {
                this.parent('.form-group').toggleClass('has-error', erred);
                return this;
            };
        });
        var currentTab = 0;
        showTab(currentTab);
        function showTab(n) {
            var x = document.getElementsByClassName("tab");
            if (n >= 0 && n < x.length) {
                x[n].style.display = "block";
            } else {
                return;
            }
            if (n == 0) {
                document.getElementById("prevBtn").style.display = "none";
            } else {
                document.getElementById("prevBtn").style.display = "inline";
            }
            if (n == (x.length - 1)) {
                $('.cap').show();
                $('.strip').show();
                $('.razorpay').show();
                $('.paytm').show();
                $('.flutterwave').show();
                $('.paystack').show();
                $('.payumoney').show();
                $('.mollie').show();
                $('.paypal').show();
                $('.coingate').show();
                $('.mercado').show();
                document.getElementById("nextBtn").innerHTML = "Submit";
            } else {
                $('.cap').hide();
                $('.strip').hide();
                $('.razorpay').hide();
                $('.paytm').hide();
                $('.flutterwave').hide();
                $('.paystack').hide();
                $('.payumoney').hide();
                $('.mollie').hide();
                $('.paypal').hide();
                $('.coingate').hide();
                $('.mercado').hide();
                document.getElementById("nextBtn").innerHTML = "Next";
            }
            fixStepIndicator(n)
        }

        function submitForm(formData) {
            var feedbackEnabledCheck = "{{ $form->feedback_enabled }}";
            var enableSessionTimer   = "{{ $form->enable_session_timer }}";
            formData.append('ajax', true);
            $.ajax({
                type: "POST",
                url: '{{ route('forms.fill.store', $form->id) }}',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.is_success) {
                        isOpen      = false;
                        formValueId = response.formValueId;
                        if (enableSessionTimer == 1) {
                            stopTimer();
                        }
                        $('.form-card-body').html('<div class="text-center gallery" id="success_loader"> <img src="{{ asset('assets/images/success.gif') }}" class="" /><br><br><h2 class="w-100 ">' + response.message + '</h2></div>' +
                            (feedbackEnabledCheck == 1 ?
                                '<div class="col-12 text-end">' +
                                '<button class="btn btn-primary d-inline-flex align-items-center" id="btn-feedback" onclick="openFeedbackModal(' + response.formValueId + '); ">Feedback</button>' + '</div>' : '')
                        );
                        if (feedbackEnabledCheck == 1) {
                            setTimeout(() => {
                                openFeedbackModal(response.formValueId);
                            }, 2800);
                        }
                        $('#nextBtn').removeAttr('disabled').html('Submit');
                    } else {
                        show_toastr('Error!', response.message, 'danger');
                        $('#nextBtn').removeAttr('disabled').html('Submit');
                        showTab($('.tab').length - 1);
                    }
                },
                error: function(xhr) {
                    let errorMessage = 'An unexpected error occurred.';

                    if (xhr.status === 422 && xhr.responseJSON?.errors) {
                        errorMessage = Object.values(xhr.responseJSON.errors)
                            .map(messages => messages[0])
                            .join('<br>');
                        show_toastr('Error!', errorMessage, 'danger');
                    } else if (xhr.responseJSON?.message) {
                        errorMessage = xhr.responseJSON.message;
                        show_toastr('Error!', errorMessage, 'danger');
                    } else {
                        show_toastr('Error!', errorMessage, 'danger');
                    }

                    $('#nextBtn').removeAttr('disabled').html('Submit');
                    showTab($('.tab').length - 1);
                }
            });
        }

        function openFeedbackModal(formValueId) {
            var formId = "{{ $form->id }}";
            var modal  = $('#common_modal');
            var currentUrl = window.location.href;
            modal.find('.modal-title').text('');
            modal.find('.body').html('');
            $.ajax({
                url: '{{ route('feedback.create') }}',
                type: 'GET',
                data: {
                    "formId": formId,
                    'formValueId': formValueId,
                    'currentUrl': currentUrl
                },
                success: function(response) {
                    modal.find('.modal-title').text("{{ __('Submit Feedback') }}");
                    modal.find('.body').html(response.html);
                    modal.modal('show');
                    var $starRating = modal.find('.starRating');
                    if ($starRating.length) {
                        $starRating.each(function() {
                            var val = $(this).attr('data-value');
                            var num_of_star = $(this).attr('data-num_of_star');
                            $(this).rateYo({
                                rating: val,
                                halfStar: true,
                                numStars: num_of_star,
                                precision: 2,
                                onSet: function(rating, rateYoInstance) {
                                    num_of_star = $(rateYoInstance.node).attr(
                                        'data-num_of_star');
                                    var input = ($(rateYoInstance.node).attr('id'));
                                    if (num_of_star == 10) {
                                        rating = rating * 2;
                                    }
                                    $('input[name="' + input + '"]').val(rating);
                                }
                            })
                        });
                    }
                },
                error: function(xhr) {
                    console.error('Error loading feedback modal:', xhr);
                }
            });
        }

        function make_payment() {
            var formData = new FormData($('#fill-form')[0]);
            var formValueId = $('#form_value_id').val();
            if (formValueId == '') {
                @if ($form->payment_status == 1)
                    @if ($form->payment_type == 'stripe')
                        stripe.createPaymentMethod({
                            type: 'card',
                            card: card,
                        }).then(function(result) {
                            if (result.error) {
                                var errorElement = document.getElementById('card-errors');
                                errorElement.textContent = result.error.message;

                                $('#nextBtn').prop('disabled', false).html('Submit');
                            } else {
                                formData.append('payment_method_id', result.paymentMethod.id);
                                submitForm(formData);
                            }
                        });
                    @elseif ($form->payment_type == 'paytm')
                        var amount   = '{{ $form->amount }}';
                        var name     = '{{ $form->title }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id  = '{{ $form->id }}';
                        var email    = '{{ $form->email }}';
                        $.ajax({
                            type: 'POST',
                            url: "{{ route('paytm.payment') }}",
                            data: {
                                '_token': '{{ csrf_token() }}',
                                'amount': amount,
                                'name': name,
                                'email': email,
                                'mobile': '1234567890',
                                'form_id': form_id,
                                'fill_type': 'fill',
                            },
                            success: function(data) {
                                $('.paytm-pg-loader').show();
                                $('.paytm-overlay').show();
                                if (data.txnToken == "") {
                                    $('#nextBtn').removeAttr('disabled').html('Submit');
                                    show_toastr('Failed!', data.message, 'danger');
                                    $('.paytm-pg-loader').hide();
                                    $('.paytm-overlay').hide();
                                    return false;
                                }
                                invokeBlinkCheckoutPopup(data.orderId, data.txnToken, data.amount)
                            }
                        });

                        function invokeBlinkCheckoutPopup(orderId, txnToken, amount) {
                            window.Paytm.CheckoutJS.init({
                                "root": "",
                                "flow": "DEFAULT",
                                "data": {
                                    "orderId": orderId,
                                    "token": txnToken,
                                    "tokenType": "TXN_TOKEN",
                                    "amount": amount,
                                },
                                handler: {
                                    transactionStatus: function(data) {
                                        $('.paytm-pg-loader').hide();
                                        $('.paytm-overlay').hide();

                                        if (data.STATUS === "TXN_SUCCESS") {
                                            formData.append('payment_id', data.TXNID);
                                            submitForm(formData);
                                        } else {
                                            $('#nextBtn').removeAttr('disabled').html('Submit');
                                            show_toastr('Failed!', data.RESPMSG ?? 'Payment failed', 'danger');
                                        }
                                    },
                                    notifyMerchant: function notifyMerchant(eventName, data) {
                                        if (eventName == "APP_CLOSED") {
                                            $('.paytm-pg-loader').hide();
                                            $('.paytm-overlay').hide();
                                            $('#nextBtn').removeAttr('disabled').html('Submit');
                                            show_toastr('Failed!', 'Payment popup was closed.', 'danger');
                                        }
                                    }
                                }
                            }).then(function() {
                                window.Paytm.CheckoutJS.invoke();
                                formData.append('payment_id', orderId);
                                submitForm(formData);
                            });
                        }
                    @elseif ($form->payment_type == 'flutterwave')
                        var amount    = '{{ $form->amount }}';
                        var name      = '{{ $form->title }}';
                        var email     = '{{ $form->email }}';
                        var currency  = '{{ $form->currency_name }}';
                        var form_id   = '{{ $form->id }}';
                        var plan_name = '{{ $form->title }}';
                        const modal = FlutterwaveCheckout({
                            public_key: "{{ UtilityFacades::getsettings('flw_public_key') }}",
                            tx_ref: "tx-" + Date.now() + "-" + Math.floor(Math.random() * 1000),
                            amount: amount,
                            currency: currency,
                            payment_options: "card, banktransfer, ussd",
                            callback: function(payment) {
                                formData.append('payment_id', payment.transaction_id);
                                modal.close();
                                submitForm(formData);
                            },
                            onclose: function(incomplete) {
                                modal.close();
                                $('#nextBtn').removeAttr('disabled').html('Submit');
                                show_toastr('Error!', 'Payment was canceled or failed', 'danger');
                            },
                            meta: {
                                consumer_id: form_id,
                                consumer_mac: "92a3-912ba-1192a",
                            },
                            customer: {
                                email: email,
                                phone_number: "08102909304",
                                name: name,
                            },
                            customizations: {
                                title: plan_name,
                                description: "Payment for " + name,
                                logo: "{{ Storage::url($form->logo) ?? Storage::url('app-logo/78x78.png') }}",
                            },
                        });
                    @elseif ($form->payment_type == 'paystack')
                        var amount   = '{{ $form->amount }}';
                        var name     = '{{ $form->title }}';
                        var email    = '{{ $form->email }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id  = '{{ $form->id }}';
                        var handler  = PaystackPop.setup({
                            key: "{{ UtilityFacades::getsettings('paystack_public_key') }}",
                            email: email,
                            amount: (amount * 100),
                            currency: currency,
                            ref: '{{ Str::random(10) }}',
                            callback: function(response) {
                                formData.append('payment_id', response.transaction);
                                var reference = response.reference;
                                show_toastr('Done!', 'Payment complete! Reference: ' + reference, 'success');
                                submitForm(formData);
                            },
                            onClose: function() {
                                $('#nextBtn').removeAttr('disabled').html('Submit');
                                show_toastr('Failed!', 'Payment was canceled or failed','danger');
                            },
                        });
                        handler.openIframe();
                    @elseif ($form->payment_type == 'coingate')
                        var amount   = '{{ $form->amount }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id  = '{{ $form->id }}';
                        $('#cg_currency').val(currency);
                        $('#cg_amount').val(amount);
                        $('#cg_form_id').val(form_id);
                        submitForm(formData);
                        setTimeout(() => {
                            $('#coingate_payment_frms').submit();
                        }, 1500);
                    @elseif ($form->payment_type == 'payumoney')
                        var amount = '{{ $form->amount }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id = '{{ $form->id }}';
                        var created_by = '{{ $form->created_by }}';
                        $('#payumoney_currency').val(currency);
                        $('#payumoney_amount').val(amount);
                        $('#payumoney_form_id').val(form_id);
                        $('#payumoney_created_by').val(created_by);
                        setTimeout(() => {
                            $('#payumoney_payment_frms').submit();
                        }, 800);
                        submitForm(formData);
                    @elseif ($form->payment_type == 'mollie')
                        var amount = '{{ $form->amount }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id = '{{ $form->id }}';
                        var created_by = '{{ $form->created_by }}';
                        $('#mollie_currency').val(currency);
                        $('#mollie_amount').val(amount);
                        $('#mollie_form_id').val(form_id);
                        $('#mollie_created_by').val(created_by);
                        setTimeout(() => {
                            $('#mollie_payment_frms').submit();
                        }, 800);
                        submitForm(formData);
                    @elseif ($form->payment_type == 'mercado')
                        var amount = '{{ $form->amount }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id = '{{ $form->id }}';
                        var created_by = '{{ $form->created_by }}';
                        $('#mercado_currency').val(currency);
                        $('#mercado_amount').val(amount);
                        $('#mercado_form_id').val(form_id);
                        $('#mercado_created_by').val(created_by);
                        setTimeout(() => {
                            $('#mercado_payment_frms').submit();
                        }, 800);
                        submitForm(formData);
                    @elseif ($form->payment_type == 'razorpay')
                        var amount = '{{ $form->amount }}';
                        var name = '{{ $form->title }}';
                        var currency = '{{ $form->currency_name }}';
                        var form_id = '{{ $form->id }}';
                        var options = {
                            "key": "{{ UtilityFacades::getsettings('razorpay_key') }}",
                            "amount": (amount * 100),
                            "name": name,
                            'currency': currency,
                            "description": "",
                            "image": '',
                            "handler": function(response) {
                                formData.append('payment_id', response.razorpay_payment_id);
                                submitForm(formData);
                                '{{ Crypt::encrypt(['payment_id' => ',response.razorpay_payment_id,', 'plan_id' => 'plan_id', 'request_user_id' => 'user_id', 'order_id' => 'order_id', 'type' => 'razorpay']) }}';
                            },
                            "modal": {
                                "ondismiss": function () {
                                    show_toastr('Error!', 'Payment was canceled or failed', 'danger');
                                }
                            },
                            "theme": {
                                "color": "#528FF0"
                            }
                        };
                        var rzp1 = new Razorpay(options);
                        rzp1.open();
                        rzp1.on('payment.failed', function (response){
                            $('#nextBtn').removeAttr('disabled').html('Submit');
                            show_toastr('Error!', response.error.description ?? 'Payment failed', 'danger');
                        });
                    @elseif ($form->payment_type == 'offlinepayment')
                        submitForm(formData);
                    @else
                        submitForm(formData);
                    @endif
                @else
                    submitForm(formData);
                @endif
            } else {
                submitForm(formData);
            }
        }

        function nextPrev(n) {
            $('.step-' + currentTab).find('.tel').each(function() {
                if ($(this).attr('type') == 'tel') {
                    var tel = $(this).val();
                    var filter = /^\d*(?:\.\d{1,2})?$/;
                    if (filter.test(tel)) {
                        valid = true;
                    } else {
                        valid = false;
                        $(this).addClass('is-invalid');
                        return false;
                    }
                }
            });
            $('.step-' + currentTab).find('.email').each(function() {
                if ($(this).attr('type') == 'email') {
                    var emailStr = $(this).val();
                    var regex = /^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i;
                    if (emailStr != '') {
                        if (regex.test(emailStr)) {
                            valid = true;
                        } else {
                            $(this).addClass('is-invalid');
                            valid = false;
                            return false;
                        }
                    }
                }
            });
            var x = document.getElementsByClassName("tab");
            if (n == 1 && !validateForm()) return false;
            $('.tab').hide();
            currentTab = currentTab + n;
            if (currentTab >= x.length) {
                var formData = new FormData($('#fill-form')[0]);
                var $this = $("#nextBtn");
                var loadingText = '<i class="fa fa-spinner fa-spin"></i> Submitting Form';
                if ($("#nextBtn").html() !== loadingText) {
                    $this.data('original-text', $("#nextBtn").html());
                    $this.html(loadingText);
                    $this.attr('disabled', true);
                }
                @if ($form->payment_type == 'paypal')
                    if ($('#payment_id').val() == '') {
                        var errorElement = document.getElementById('paypal-errors');
                        show_toastr('Error!', "{{ __('Please make payment.') }}", 'danger');
                        $('#nextBtn').removeAttr('disabled').html('Submit');
                        showTab(n);
                        return false;
                    }
                @endif
                make_payment();
                return false;
            }
            showTab(currentTab);
        }

        function validateForm() {
            var check = [];
            $('.step-' + currentTab).find('.required').each(function() {
                var name = $(this).attr('name');
                if ($(this).val() == "") {
                    $(this).addClass('is-invalid');
                    check.push(false);
                } else {
                    $(this).removeClass('is-invalid');
                    $(this).addClass('is-valid');
                    check.push(true);
                }
                if ($(this).is('input[type="hidden"]') && $(this).attr('class')?.includes('SignaturePad-')) {
                    if ($(this).parents('.signature-pad-body').length) {
                        if ($(this).val() == "") {
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').addClass('is-invalid');
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').removeClass('is-valid');
                            show_toastr('Error!', '{{ __('Please save your signature.') }}', 'danger');
                            check.push(false);
                        } else {
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').addClass('is-valid');
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').removeClass('is-invalid');
                            check.push(true);
                        }
                    }
                    if ($(this).parents('.cam-buttons').length) {
                        var videoContainer = $(this).parents('.cam-buttons');
                        var videoCam = videoContainer.find('.video_cam');
                        if (videoContainer.find('input[name="media"]').val() == "") {
                            videoCam.addClass('is-invalid');
                            videoCam.removeClass('is-valid');
                            show_toastr('Error!', '{{ __('Video recording field is required.') }}', 'danger');
                            check.push(false);
                        } else {
                            videoCam.addClass('is-valid');
                            videoCam.removeClass('is-invalid');
                            check.push(true);
                        }
                    }
                    if ($(this).parents('.selfie_screen').length) {
                        var videoContainer = $(this).parents('.selfie_screen');
                        var videoCam = videoContainer.find('.selfie_photo');
                        if (videoContainer.find('input[name="image"]').val() == "") {
                            videoCam.addClass('is-invalid');
                            videoCam.removeClass('is-valid');
                            show_toastr('Error!', '{{ __('This selfie field is required.') }}', 'danger');
                            check.push(false);
                        } else {
                            videoCam.addClass('is-valid');
                            videoCam.removeClass('is-invalid');
                            check.push(true);
                        }
                    }
                }
                if ($(this).attr('type') === 'email') {
                    const emailStr = $(this).val().trim();
                    const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

                    if (emailStr === '') {
                        $(this).removeClass('is-valid').addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        check.push(false);
                    } else if (!regex.test(emailStr)) {
                        $(this).removeClass('is-valid').addClass('is-invalid');
                        $(this).next().html('Please enter a valid email address.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid').addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'tel') {
                    var tel = $(this).val();
                    var filter = /^\d*(?:\.\d{1,2})?$/;
                    if (filter.test(tel)) {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        check.push(true);
                    } else {
                        $(this).addClass('invalid');
                        check.push(false);
                    }
                }
                if ($(this).attr('type') == 'radio') {
                    if ($('input[name="' + name + '"]:checked').length <= 0) {
                        $(this).addClass('is-invalid');
                        $('.required-radio').html('Select any one');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $('.required-radio').html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'checkbox') {
                    if ($('input[name="' + name + '"]:checked').length <= 0) {
                        $(this).addClass('is-invalid');
                        $('.required-checkbox').html('Select any one');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $('.required-checkbox').html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'number') {
                    var numval = parseInt($(this).val());
                    var min = parseInt($(this).attr('min'));
                    var max = parseInt($(this).attr('max'));
                    if ($(this).val() == "") {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        $(this).removeClass('is-valid');
                        check.push(false);
                    } else {
                        if (isNaN(min) == false && isNaN(max) == true && min > numval) {
                            $(this).addClass('is-invalid')
                            $(this).parent().find('.required-number').html('Sorry minimum number is ' + min + '.');
                            $(this).removeClass('is-valid');
                            check.push(false);
                        } else if (isNaN(min) == true && isNaN(max) == false && max < numval) {
                            $(this).addClass('is-invalid')
                            $(this).parent().find('.required-number').html('Sorry maximum number is ' + max + '.');
                            $(this).removeClass('is-valid');
                            check.push(false);
                        } else if (isNaN(min) == false && isNaN(max) == false && (min > numval || numval > max)) {
                            $(this).addClass('is-invalid')
                            $(this).parent().find('.required-number').html('Select between minimum number ' + min +
                                ' and maximum number ' + max + '.');
                            $(this).removeClass('is-valid');
                            check.push(false);
                        } else {
                            $(this).removeClass('is-invalid');
                            $(this).addClass('is-valid');
                            $(this).parent().find('.required-number').html('');
                            check.push(true);
                        }
                    }
                }

                if ($(this).attr('type') == 'file') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please select file in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }

                if ($(this).attr('type') == 'date') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please select date in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }

                if ($(this)[0].localName == 'textarea') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }

                if ($(this).attr('type') == 'text') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }
            });
            var valid = true;
            check.forEach(function(val) {
                if (val == false) {
                    valid = false;
                    return false;
                }
            });
            if (valid) {
                $('.step-' + currentTab).addClass('finish');
            }
            return valid;
        }

        $(document).on("click", "input[type='checkbox']", function() {
            var name = $(this).attr('name');
            checkCheckbox(name);
        });
        $("body input[type='checkbox']").each(function(i, item) {
            var name = $(item).attr('name');
            checkCheckbox(name);
        });

        function checkCheckbox(name) {
            if ($("input[name='" + name + "']:checked").length) {
                $("input[name='" + name + "']").removeAttr('required');
            } else {
                $("input[name='" + name + "']").attr('required', 'required');
            }
        }

        function fixStepIndicator(n) {
            var i, x = document.getElementsByClassName("step");
            for (i = 0; i < x.length; i++) {
                x[i].className = x[i].className.replace(" active", "");
            }
            x[n].className += " active";
        }
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var genericExamples = document.querySelectorAll('[data-trigger]');
            for (i = 0; i < genericExamples.length; ++i) {
                var element = genericExamples[i];
                new Choices(element, {
                    placeholderValue: 'Select Option',
                    searchPlaceholderValue: 'Search Option',
                });
            }
        });
    </script>
    <script src="{{ asset('vendor/ckeditor/ckeditor.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom_select").select2();
        });
        var $starRating = $('.starRating');
        if ($starRating.length) {
            $starRating.each(function() {
                var val = $(this).attr('data-value');
                var num_of_star = $(this).attr('data-num_of_star');
                $(this).rateYo({
                    rating: val,
                    halfStar: true,
                    numStars: num_of_star,
                    precision: 2,
                    onSet: function(rating, rateYoInstance) {
                        num_of_star = $(rateYoInstance.node).attr('data-num_of_star');
                        var input = ($(rateYoInstance.node).attr('id'));
                        if (num_of_star == 10) {
                            rating = rating * 2;
                        }
                        $('input[name="' + input + '"]').val(rating);
                    }
                })
            });
        }
        if ($(".ck_editor").length) {
            CKEDITOR.replace($('.ck_editor').attr('name'), {
                filebrowserUploadUrl: "{{ route('ckeditor.upload', ['_token' => csrf_token()]) }}",
                filebrowserUploadMethod: 'form'
            });
        }
    </script>
    <script type="text/javascript" src="https://js.stripe.com/v3/"></script>
@endpush
