@php
    use App\Facades\UtilityFacades;
@endphp
@extends('layouts.form')
@section('title', __('Fill'))
@section('content')
    <div class="p-0 main-content">
        <section class="section">
            <div class="mx-auto mt-3 col-md-7">
                <div class="card">
                    <div class="card-header">
                        <h5 class="text-center">{{ $booking->business_name }}</h5>
                    </div>
                    <div class="row">
                        <div class="mb-3 col-lg-12">
                            <div class="custom-card">
                                <div class="p-3 border card-body">
                                    <div class="form-check">
                                        <label class="h6">
                                            <strong class="float-start fw-bold">{{ __('Email : ') }}</strong>
                                            <span class="float-end">{{ $booking->business_email }}</span>
                                        </label>
                                        <div class="clearfix"></div>
                                        <label class="h6">
                                            <strong class="float-start fw-bold">{{ __('Website : ') }}</strong>
                                            <span class="float-end">{{ $booking->business_website }}</span>
                                        </label>
                                        <div class="clearfix"></div>
                                        <label class="h6">
                                            <strong class="float-start fw-bold">{{ __('Phone :') }}</strong>
                                            <span class="float-end">{{ $booking->business_phone }}</span>
                                        </label>
                                        <div class="clearfix"></div>
                                        <label class="h6">
                                            <strong class="float-start fw-bold">{{ __('Number :') }}</strong>
                                            <span class="float-end">{{ $booking->business_number }}</span>
                                        </label>
                                        <div class="clearfix"></div>
                                        <label class="h6">
                                            <strong class="float-start fw-bold">{{ __('Address :') }}</strong>
                                            <span class="float-end">{{ $booking->business_address }}</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <form action="{{ route('booking.fill.store', $booking->id) }}" method="POST" enctype="multipart/form-data" id="fill-form">
                        @method('PUT')
                        @csrf
                        <div class="card-body form-card-body">
                            <div id="booking-step1" class="row booking-step">
                                @include('bookings.appoinment.seat.index')
                            </div>
                            <div id="booking-step2" class="row booking-step d-none">
                                @include('bookings.appoinment.seat.seat')
                            </div>
                            <div id="booking-step3" class="row booking-step d-none">
                                <div class="col-lg-12">
                                    @include('bookings.multi-form')
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="mb-3 btn-flt float-start">
                                <button id="prevButton" type="button" class="btn btn-secondary d-none"><i
                                        class="ti ti-chevron-left me-2"></i>{{ __('Previous') }}</button>
                            </div>
                            <div class="mb-3 btn-flt float-end">
                                <button id="nextButton" type="button" class="btn btn-primary">{{ __('Next') }}<i
                                        class="ti ti-chevron-right ms-2"></i></button>
                                <button class="btn btn-primary d-none" id="submitButton" onclick="nextPrev(1);"
                                    type="button">{{ __('Submit') }}</button>
                            </div>
                        </div>
                        <div class="extra_style">
                            @foreach ($array as $keys => $rows)
                                <span class="step"></span>
                            @endforeach
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('style')
    <link href="{{ asset('assets/jqueryform/css/jquery.rateyo.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('vendor/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/plugins/flatpickr.min.css') }}">
@endpush
@push('script')
    <script src="{{ asset('vendor/jqueryform/js/jquery.rateyo.min.js') }}"></script>
    <script src="{{ asset('vendor/js/jquery.payment.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/flatpickr.min.js') }}"></script>
    <script src="{{ asset('vendor/select2/js/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script type="text/javascript" src="https://js.stripe.com/v3/"></script>
    @if (Utility::getsettings('PAYPAL_SANDBOX_CLIENT_ID'))
        <script src="https://www.paypal.com/sdk/js?client-id={{ Utility::getsettings('PAYPAL_SANDBOX_CLIENT_ID') }}&currency={{ $booking->currency_name ?? 'USD' }}"></script>
    @endif
    @if (Utility::getsettings('PAYTM_MERCHANT_ID'))
        <script type="application/javascript" crossorigin="anonymous" src="https://{{ Utility::getsettings('PAYTM_ENVIRONMENT') == 'production' ? 'securegw.paytm.in' : 'securegw-stage.paytm.in' }}/merchantpgpui/checkoutjs/merchants/{{ Utility::getsettings('PAYTM_MERCHANT_ID') }}.js"></script>
    @endif
    <script src="https://checkout.flutterwave.com/v3.js"></script>
    <script src="https://js.paystack.co/v1/inline.js"></script>
    <script>
        $(document).ready(function() {
            var currentStep = 1;
            function showStep(stepNumber) {
                $('.booking-step').addClass('d-none');
                $('#booking-step' + stepNumber).removeClass('d-none');
                if (currentStep === 3) {
                    $('#nextButton').addClass('d-none');
                    $('#submitButton').removeClass('d-none');
                    $('#prevButton').removeClass('d-none');
                } else if (currentStep === 1) {
                    $('#nextButton').removeClass('d-none');
                    $('#submitButton').addClass('d-none');
                    $('#prevButton').addClass('d-none');
                } else {
                    $('#submitButton').addClass('d-none');
                    $('#nextButton').removeClass('d-none');
                    $('#prevButton').removeClass('d-none');
                }
            }
            // Function to go to the next booking-step
            function nextStep() {
                if (currentStep < 3) {
                    currentStep++;
                    showStep(currentStep);
                }
            }
            // Function to go back to the previous booking-step
            function prevStep() {
                if (currentStep > 1) {
                    currentStep--;
                    showStep(currentStep);
                }
            }
            // Attach event handlers for navigation buttons
            $('#nextButton').click(nextStep);
            $('#prevButton').click(prevStep);
            $(document).on('click', 'input[name="seat[]"]', function() {
                var limitSlots = parseInt({{ $seatWiseBooking->multiple_booking_limit }});
                var SelectedSlots = $('input[name="seat[]"]:checked');
                if (SelectedSlots.length >= limitSlots) {
                    $('input[name="seat[]"]:not(:checked)').attr('disabled', true);
                } else {
                    $('input[name="seat[]"]').attr('disabled', false);
                    $('input[name="seat[]"].disabled').attr('disabled', true);
                }
            });
            var session = $('input[name="session_time"]:checked').val();
            getappointmentSlot(session);
        });

        var flatpickrInstance;
        document.addEventListener('DOMContentLoaded', function() {
            var datepickerEl = document.querySelector('#pc-datepicker');
            var bookingStartDate = new Date("{{ $bookingStartDate }}");
            var bookingEndDate = new Date("{{ $bookingEndDate }}");
            var currHour       = '{{ $currDate->format('h') }}';
            var currMinute     = '{{ $currDate->format('i') }}';
            bookingStartDate.setHours(currHour, currMinute, 0, 0);
            bookingEndDate.setHours(currHour, currMinute, 0, 0);

            var selectedDays = {!! json_encode($selectedDays) !!};
            // Set current date with hours and minutes
            var currentDate = new Date();
            currentDate.setHours(currHour, currMinute, 0, 0);
            flatpickrInstance = flatpickr(datepickerEl, {
                inline: true,
                disableMobile: true,
                defaultDate: (currentDate >= bookingStartDate && currentDate <= bookingEndDate &&
                    selectedDays.includes(currentDate.getDay())) ? currentDate : null,
                enable: [
                    function(date) {
                        var pickerDate = new Date(date);
                        pickerDate.setHours(currHour, currMinute, 0, 0);
                        var dayOfWeek = date.getDay();
                        var isNotSelected = selectedDays.includes(dayOfWeek);
                        var enable = pickerDate >= bookingStartDate && pickerDate <= bookingEndDate &&
                            pickerDate >= currentDate && isNotSelected;
                        return enable;
                    }
                ],
                onChange: function(selectedDates, dateStr, instance) {
                    getappointmentSlot(dateStr);
                }
            });
            getappointmentSlot();
        });

        function getappointmentSlot(selectedDate = '{{ $currDate->format('Y-m-d') }}') {
            var url = '{{ route('booking.seats.slot.appoinment.get', $booking->id) }}';
            $.ajax({
                type: "POST",
                url: url,
                data: {
                    _token: "{{ csrf_token() }}",
                    date: selectedDate,
                },
                success: function(response) {
                    $('.appointmentSlot').empty().html(response.html);
                    $('input[name="booking_date"]').val(selectedDate);
                },
                error: function(error) {}
            });
        }

        function getappointmentSlotSeat(session, date) {
            var url = '{{ route('booking.seats.seat.appoinment.get', $booking->id) }}';
            $.ajax({
                type: "POST",
                url: url,
                data: {
                    _token: "{{ csrf_token() }}",
                    session: session,
                    date: date,
                },
                success: function(response) {
                    $('#seat-table tbody').empty().html(response.html);
                    var limitSlots = parseInt({{ $seatWiseBooking->multiple_booking_limit }});
                    var SelectedSlots = $('input[name="seat[]"]:checked');
                    if (SelectedSlots.length >= limitSlots) {
                        $('input[name="seat[]"]:not(:checked)').attr('disabled', true);
                    } else {
                        $('input[name="seat[]"]').attr('disabled', false);
                        $('input[name="seat[]"].disabled').attr('disabled', true);
                    }
                },
                error: function(error) {}
            });
        }

        $(document).on('click', 'input[name="session_time"]', function() {
            var session = $(this).val();
            var date = $('input[name="booking_date"]').val();
            getappointmentSlotSeat(session, date);
        });

        $(window).on('load', function () {
            setTimeout(function () {
                var session = $('input[name="session_time"]:checked').val();
                var date = $('input[name="booking_date"]').val();

                if (session && date) {
                    getappointmentSlotSeat(session, date);
                }
            }, 300);
        });

        var bookingValueId = $('#booking_value_id').val();
        var SITEURL = '{{ URL::to('') }}';
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        ('restrictNumeric');
        $('.cc-number').payment('formatCardNumber');
        $('.cc-exp').payment('formatCardExpiry');
        $('.cc-cvc').payment('formatCardCVC');
        $.fn.toggleInputError = function(erred) {
            this.parent('.form-group').toggleClass('has-error', erred);
            return this;
        };

        var currentTab = 0;
        function nextPrev(n) {
            $('.step-' + currentTab).find('.tel').each(function() {
                if ($(this).attr('type') == 'tel') {
                    var tel = $(this).val();
                    var filter = /^\d*(?:\.\d{1,2})?$/;
                    if (filter.test(tel)) {
                        valid = true;
                    } else {
                        valid = false;
                        $(this).addClass('is-invalid');
                        return false;
                    }
                }
            });
            $('.step-' + currentTab).find('.email').each(function() {
                if ($(this).attr('type') == 'email') {
                    var emailStr = $(this).val();
                    var regex = /^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i;
                    if (emailStr != '') {
                        if (regex.test(emailStr)) {
                            valid = true;
                        } else {
                            $(this).addClass('is-invalid');
                            valid = false;
                            return false;
                        }
                    }
                }
            });
            if (n == 1 && !validateForm()) return false;
            var formData = new FormData($('#fill-form')[0]);
            var $this = $("#submitButton");
            var loadingText = '<i class="fa fa-spinner fa-spin"></i> Submitting Form';
            if ($("#submitButton").html() !== loadingText) {
                $this.data('original-text', $("#submitButton").html());
                $this.html(loadingText);
                $this.attr('disabled', true);
            }
            @if ($booking->payment_type == 'paypal')
                if ($('#payment_id').val() == '') {
                    var errorElement = document.getElementById('paypal-errors');
                    show_toastr('Error!', '{{ __('Please make payment') }}', 'danger');
                    $('#submitButton').prop('disabled', false).html('Submit');
                    return false;
                }
            @endif
            make_payment();
        }

        function validateForm() {
            var currentTab = 0;
            var check = [];
            $('.step-' + currentTab).find('.required').each(function() {
                var name = $(this).attr('name');
                if ($(this).val() == "") {
                    $(this).addClass('is-invalid');
                    check.push(false);
                } else {
                    $(this).removeClass('is-invalid');
                    $(this).addClass('is-valid');
                    check.push(true);
                }
                if ($(this).attr('type') == 'hidden') {
                    if ($(this).parents('.signature-pad-body').length) {
                        if ($(this).val() == "") {
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').addClass('is-invalid');
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').removeClass('is-valid');
                            show_toastr('Error!', '{{ __('Please save your signature.') }}', 'danger');
                            check.push(false);
                        } else {
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').addClass('is-valid');
                            $(this).parents('.signature-pad-body').find('input[name="' + $(this).attr('name') + '"]').removeClass('is-invalid');
                            check.push(true);
                        }
                    }
                    if ($(this).parents('.cam-buttons').length) {
                        var videoContainer = $(this).parents('.cam-buttons');
                        var videoCam = videoContainer.find('.video_cam');
                        if (videoContainer.find('input[name="media"]').val() == "") {
                            videoCam.addClass('is-invalid');
                            videoCam.removeClass('is-valid');
                            show_toastr('Error!', '{{ __('Video recording field is required.') }}', 'danger');
                            check.push(false);
                        } else {
                            videoCam.addClass('is-valid');
                            videoCam.removeClass('is-invalid');
                            check.push(true);
                        }
                    }
                    if ($(this).parents('.selfie_screen').length) {
                        var videoContainer = $(this).parents('.selfie_screen');
                        var videoCam = videoContainer.find('.selfie_photo');
                        if (videoContainer.find('input[name="image"]').val() == "") {
                            videoCam.addClass('is-invalid');
                            videoCam.removeClass('is-valid');
                            show_toastr('Error!', '{{ __('This selfie field is required.') }}', 'danger');
                            check.push(false);
                        } else {
                            videoCam.addClass('is-valid');
                            videoCam.removeClass('is-invalid');
                            check.push(true);
                        }
                    }
                }
                if ($(this).attr('type') == 'email') {
                    var emailStr = $(this).val();
                    var regex = /^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i;
                    if (regex.test(emailStr)) {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        check.push(true);
                    } else {
                        $(this).addClass('is-invalid');
                        check.push(false);
                    }
                }
                if ($(this).attr('type') == 'tel') {
                    var tel = $(this).val();
                    var filter = /^\d*(?:\.\d{1,2})?$/;
                    if (filter.test(tel)) {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        check.push(true);
                    } else {
                        $(this).addClass('invalid');
                        check.push(false);
                    }
                }
                if ($(this).attr('type') == 'radio') {
                    if ($('input[name="' + name + '"]:checked').length <= 0) {
                        $(this).addClass('is-invalid');
                        $('.required-radio').html('Select any one');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $('.required-radio').html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'checkbox') {
                    if ($('input[name="' + name + '"]:checked').length <= 0) {
                        $(this).addClass('is-invalid');
                        $('.required-checkbox').html('Select any one');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $('.required-checkbox').html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'number') {
                    var numval = parseInt($(this).val());
                    var min = parseInt($(this).attr('min'));
                    var max = parseInt($(this).attr('max'));
                    if ($(this).val() == "") {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        $(this).removeClass('is-valid');
                        check.push(false);
                    } else {
                        if (isNaN(min) == false && isNaN(max) == true && min > numval) {
                            $(this).addClass('is-invalid')
                            $(this).parent().find('.required-number').html('Sorry minimum number is ' + min + '.');
                            $(this).removeClass('is-valid');
                            check.push(false);
                        } else if (isNaN(min) == true && isNaN(max) == false && max < numval) {
                            $(this).addClass('is-invalid')
                            $(this).parent().find('.required-number').html('Sorry maximum number is ' + max + '.');
                            $(this).removeClass('is-valid');
                            check.push(false);
                        } else if (isNaN(min) == false && isNaN(max) == false && (min > numval || numval > max)) {
                            $(this).addClass('is-invalid')
                            $(this).parent().find('.required-number').html('Select between minimum number ' + min +
                                ' and maximum number ' + max + '.');
                            $(this).removeClass('is-valid');
                            check.push(false);
                        } else {
                            $(this).removeClass('is-invalid');
                            $(this).addClass('is-valid');
                            $(this).parent().find('.required-number').html('');
                            check.push(true);
                        }
                    }
                }
                if ($(this).attr('type') == 'file') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please select file in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'date') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please select date in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }
                if ($(this)[0].localName == 'textarea') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }
                if ($(this).attr('type') == 'text') {
                    var inp = $(this).val();
                    if (inp.length == 0) {
                        $(this).addClass('is-invalid');
                        $(this).next().html('Please fill in this field.');
                        check.push(false);
                    } else {
                        $(this).removeClass('is-invalid');
                        $(this).addClass('is-valid');
                        $(this).next().html('');
                        check.push(true);
                    }
                }
            });
            var valid = true;
            check.forEach(function(val) {
                if (val == false) {
                    valid = false;
                    return false;
                }
            });
            if (valid) {
                $('.step-' + currentTab).addClass('finish');
            }
            return valid;
        }

        function make_payment() {
            var formData = new FormData($('#fill-form')[0]);
            if (bookingValueId == '') {
                @if ($booking->payment_status == 1)
                    @if ($booking->payment_type == 'stripe')
                        stripe.createPaymentMethod({
                            type: 'card',
                            card: card,
                        }).then(function(result) {
                            if (result.error) {
                                var errorElement = document.getElementById('card-errors');
                                errorElement.textContent = result.error.message;

                            $('#submitButton').prop('disabled', false).html('Submit');
                            } else {
                                formData.append('payment_method_id', result.paymentMethod.id);
                                submitForm(formData);
                            }
                        });
                    @elseif ($booking->payment_type == 'paytm')
                        var amount     = '{{ $booking->amount }}';
                        var name       = '{{ $booking->business_name }}';
                        var currency   = '{{ $booking->currency_name }}';
                        var form_id    = '{{ $booking->id }}';
                        var email      = '{{ $booking->business_email }}';
                        var succes_msg = '{{ $booking->success_msg }}';
                        $.ajax({
                            type: 'POST',
                            url: "{{ route('paymentpaytm.payment') }}",
                            data: {
                                '_token': '{{ csrf_token() }}',
                                'amount': amount,
                                'name': name,
                                'email': email,
                                'mobile': '123456789',
                                'succes_msg': succes_msg,
                                'form_id': form_id,
                            },
                            success: function(data) {
                                $('.paytm-pg-loader').show();
                                $('.paytm-overlay').show();
                                if (data.txnToken == "") {
                                    $('#submitButton').prop('disabled', false).html('Submit');
                                    show_toastr('Error!', data.message, 'danger');
                                    $('.paytm-pg-loader').hide();
                                    $('.paytm-overlay').hide();
                                    return false;
                                }
                                invokeBlinkCheckoutPopup(data.orderId, data.txnToken, data.amount)
                            }
                        });

                        function invokeBlinkCheckoutPopup(orderId, txnToken, amount) {
                            window.Paytm.CheckoutJS.init({
                                "root": "",
                                "flow": "DEFAULT",
                                "data": {
                                    "orderId": orderId,
                                    "token": txnToken,
                                    "tokenType": "TXN_TOKEN",
                                    "amount": amount,
                                },
                                handler: {
                                    transactionStatus: function(data) {
                                        $('.paytm-pg-loader').hide();
                                        $('.paytm-overlay').hide();

                                        if (data.STATUS === "TXN_SUCCESS") {
                                            formData.append('payment_id', data.TXNID);
                                            submitForm(formData);
                                        } else {
                                            $('#submitButton').prop('disabled', false).html('Submit');
                                            show_toastr('Error!', data.RESPMSG ?? 'Payment failed', 'danger');
                                        }
                                    },
                                    notifyMerchant: function notifyMerchant(eventName, data) {
                                        if (eventName == "APP_CLOSED") {
                                            $('.paytm-pg-loader').hide();
                                            $('.paytm-overlay').hide();
                                            $('#submitButton').prop('disabled', false).html('Submit');
                                            show_toastr('Error!', 'Payment popup was closed.', 'danger');
                                        }
                                    }
                                }
                            }).then(function() {
                                window.Paytm.CheckoutJS.invoke();
                                formData.append('payment_id', orderId);
                                submitForm(formData);
                            });
                        }
                    @elseif ($booking->payment_type == 'flutterwave')
                        var amount    = '{{ $booking->amount }}';
                        var name      = '{{ $booking->business_name }}';
                        var email     = '{{ $booking->business_email }}';
                        var currency  = '{{ $booking->currency_name }}';
                        var form_id   = '{{ $booking->id }}';
                        var plan_name = '{{ $booking->business_name }}';
                        const modal = FlutterwaveCheckout({
                            public_key: "{{ UtilityFacades::getsettings('flw_public_key') }}",
                            tx_ref: "tx-" + Date.now() + "-" + Math.floor(Math.random() * 1000),
                            amount: amount,
                            currency: currency,
                            payment_options: "card, banktransfer, ussd",
                            callback: function(payment) {
                                formData.append('payment_id', payment.transaction_id);
                                modal.close();
                                submitForm(formData);
                            },
                            onclose: function(incomplete) {
                                modal.close();
                                $('#submitButton').prop('disabled', false).html('Submit');
                                show_toastr('Error!', 'Transaction was not completed, window closed.','danger');
                            },
                            meta: {
                                consumer_id: form_id,
                                consumer_mac: "92a3-912ba-1192a",
                            },
                            customer: {
                                email: email,
                                phone_number: "08102909304",
                                name: name,
                            },
                            customizations: {
                                title: plan_name,
                                description: "Payment for " + name,
                                logo: "{{ Storage::url($booking->business_logo) ?? Storage::url('app-logo/78x78.png') }}",
                            },
                        });
                    @elseif ($booking->payment_type == 'paystack')
                        var amount   = '{{ $booking->amount }}';
                        var name     = '{{ $booking->business_name }}';
                        var email    = '{{ $booking->business_email }}';
                        var currency = '{{ $booking->currency_name }}';
                        var form_id  = '{{ $booking->id }}';
                        var handler  = PaystackPop.setup({
                            key: "{{ UtilityFacades::getsettings('paystack_public_key') }}",
                            email: email,
                            amount: (amount * 100),
                            currency: currency,
                            ref: '{{ Str::random(10) }}',
                            callback: function(response) {
                                formData.append('payment_id', response.transaction);
                                var reference = response.reference;
                                show_toastr('Done!', 'Payment complete! Reference: ' + reference, 'success');
                                submitForm(formData);
                            },
                            onClose: function() {
                                $('#submitButton').prop('disabled', false).html('Submit');
                                show_toastr('Error!', 'Payment was canceled or failed','danger');
                            },
                        });
                        handler.openIframe();
                    @elseif ($booking->payment_type == 'payumoney')
                        var amount     = '{{ $booking->amount }}';
                        var currency   = '{{ $booking->currency_name }}';
                        var form_id    = '{{ $booking->id }}';
                        var created_by = '{{ $booking->created_by }}';
                        $('#payumoney_currency').val(currency);
                        $('#payumoney_amount').val(amount);
                        $('#payumoney_form_id').val(form_id);
                        $('#payumoney_created_by').val(created_by);
                        setTimeout(() => {
                            $('#payumoney_payment_frms').submit();
                        }, 800);
                        submitForm(formData);
                    @elseif ($booking->payment_type == 'coingate')
                        var amount     = '{{ $booking->amount }}';
                        var currency   = '{{ $booking->currency_name }}';
                        var form_id    = '{{ $booking->id }}';
                        var created_by = '{{ $booking->created_by }}';
                        $('#cg_currency').val(currency);
                        $('#cg_amount').val(amount);
                        $('#cg_form_id').val(form_id);
                        $('#cg_created_by').val(created_by);
                        submitForm(formData);
                        setTimeout(() => {
                            $('#coingate_payment_frms').submit();
                        }, 1500);
                    @elseif ($booking->payment_type == 'mercado')
                        var amount = '{{ $booking->amount }}';
                        var currency = '{{ $booking->currency_name }}';
                        var form_id = '{{ $booking->id }}';
                        var created_by = '{{ $booking->created_by }}';
                        $('#mercado_currency').val(currency);
                        $('#mercado_amount').val(amount);
                        $('#mercado_form_id').val(form_id);
                        $('#mercado_created_by').val(created_by);
                        $('#mercado_payment_frms').submit();
                        submitForm(formData);
                    @elseif ($booking->payment_type == 'razorpay')
                        var amount = '{{ $booking->amount }}';
                        var name = '{{ $booking->business_name }}';
                        var currency = '{{ $booking->currency_name }}';
                        var form_id = '{{ $booking->id }}';
                        var data = {
                            "_token": "{{ csrf_token() }}",
                            'price': amount,
                            'name': name,
                            'currency': currency,
                            'form_id': form_id,
                        }
                        var options = {
                            "key": "{{ UtilityFacades::getsettings('razorpay_key') }}",
                            "amount": (amount * 100),
                            "name": name,
                            'currency': currency,
                            "description": "",
                            "image": '',
                            "handler": function(response) {
                                formData.append('payment_id', response.razorpay_payment_id);
                                submitForm(formData);
                                '{{ Crypt::encrypt(['payment_id' => ',response.razorpay_payment_id,', 'plan_id' => 'plan_id', 'request_user_id' => 'user_id', 'order_id' => 'order_id', 'type' => 'razorpay']) }}';
                            },
                            "modal": {
                                "ondismiss": function () {
                                    show_toastr('Error!', 'Payment was canceled or failed', 'danger');
                                }
                            },
                            "theme": {
                                "color": "#528FF0"
                            }
                        };
                        var rzp1 = new Razorpay(options);
                        rzp1.open();
                        rzp1.on('payment.failed', function (response){
                            $('#submitButton').prop('disabled', false).html('Submit');
                            show_toastr('Error!', response.error.description ?? 'Payment failed', 'danger');
                        });
                    @elseif ($form->payment_type == 'offlinepayment')
                        submitForm(formData);
                    @else
                        submitForm(formData);
                    @endif
                @else
                    submitForm(formData);
                @endif
            } else {
                submitForm(formData);
            }
        }

        function submitForm(formData) {
            var url = $('#fill-form').attr('action');
            formData.append('ajax', true);
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: url,
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.is_success) {
                        $('.form-card-body').html(
                            '<div class="text-center gallery" id="success_loader"><img src="{{ asset('assets/images/success.gif') }}" /><br><br><h2 class="w-100 ">Your booking is successfully ' +
                            'completed!</h2></div>');
                        $('#success_loader').after(
                            '<div class="text-center">Click to view your booking details: <a target="_blank" href="' +
                            response.redirect + '">Click Here</a></div>');
                        $('.card-footer').addClass('d-none');
                    } else {
                        show_toastr('Error!', response.message, 'danger');
                    }
                    $('#submitButton').prop('disabled', false).html('Submit');
                },
                error: function(error) {}
            });
        }

        $(document).on("click", "input[type='checkbox']", function() {
            var name = $(this).attr('name');
            checkCheckbox(name);
        });

        $("body input[type='checkbox']").each(function(i, item) {
            var name = $(item).attr('name');
            checkCheckbox(name);
        });

        function checkCheckbox(name) {
            if ($("input[name='" + name + "']:checked").length) {
                $("input[name='" + name + "']").removeAttr('required');
            } else {
                $("input[name='" + name + "']").attr('required', 'required');
            }
        }

        function fixStepIndicator(n) {
            var i, x = document.getElementsByClassName("step");
            for (i = 0; i < x.length; i++) {
                x[i].className = x[i].className.replace(" active", "");
            }
            x[n].className += " active";
        }
    </script>
    <script>
        $(document).ready(function() {
            setTimeout(function() {
                $("#setData").trigger('click');
            }, 30);
        });
        document.addEventListener('DOMContentLoaded', function() {
            var genericExamples = document.querySelectorAll('[data-trigger]');
            for (i = 0; i < genericExamples.length; ++i) {
                var element = genericExamples[i];
                new Choices(element, {
                    placeholderValue: 'Select Option',
                    searchPlaceholderValue: 'Search Option',
                });
            }
        });
        var element = document.getElementById('choices-multiple-remove-button');
        if (element) {
            var multipleCancelButton = new Choices(element, {
                removeItemButton: true,
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $(".custom_select").select2();
        })
        var $starRating = $('.starRating');
        if ($starRating.length) {
            $starRating.each(function() {
                var val = $(this).attr('data-value');
                var num_of_star = $(this).attr('data-num_of_star');
                $(this).rateYo({
                    rating: val,
                    halfStar: true,
                    numStars: num_of_star,
                    precision: 2,
                    onSet: function(rating, rateYoInstance) {
                        num_of_star = $(rateYoInstance.node).attr('data-num_of_star');
                        var input = ($(rateYoInstance.node).attr('id'));
                        if (num_of_star == 10) {
                            rating = rating * 2;
                        }
                        $('input[name="' + input + '"]').val(rating);
                    }
                })
            });
        }
        if ($(".ck_editor").length) {
            CKEDITOR.replace($('.ck_editor').attr('name'), {
                filebrowserUploadUrl: "{{ route('ckeditor.upload', ['_token' => csrf_token()]) }}",
                filebrowserUploadMethod: 'form'
            });
        }
    </script>
    @if ($booking->payment_status == 1)
        <script>
            var stripe, card;
            $(document).ready(function() {
                @if ($booking->payment_status == 1)
                    @if ($booking->payment_type == 'stripe')
                        stripe = Stripe('{{ Utility::getsettings('stripe_key') }}');
                        var elements = stripe.elements();
                        var style = {
                            base: {
                                color: '#32325d',
                                lineHeight: '24px',
                                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                                fontSmoothing: 'antialiased',
                                fontSize: '18px',
                                '::placeholder': {
                                    color: '#aab7c4'
                                }
                            },
                            invalid: {
                                color: '#fa755a',
                                iconColor: '#fa755a'
                            }
                        };
                        card = elements.create('card', {
                            style: style
                        });
                        card.mount('#card-element');
                        card.addEventListener('change', function(event) {
                            var displayError = document.getElementById('card-errors');
                            displayError.textContent = event.error ? event.error.message : '';
                        });
                    @endif
                    @if ($booking->payment_type == 'paypal')
                        var amount     = '{{ $booking->amount }}';
                        var name       = '{{ $booking->business_name }}';
                        var currency   = '{{ $booking->currency_name }}';
                        paypal.Buttons({
                            createOrder: function(data, actions) {
                                return actions.order.create({
                                    purchase_units: [{
                                        amount: {
                                            value: amount,
                                            currency_code: currency
                                        },
                                        description: name
                                    }]
                                });
                            },
                            onApprove: function(data, actions) {
                                return actions.order.capture().then(function(orderData) {
                                    var transaction = orderData.purchase_units[0].payments.captures[0];
                                    $('#payment_id').val(transaction.id);
                                    var errorElement = document.getElementById('paypal-errors');
                                    errorElement.textContent = '';
                                    $('#paypal-button-container').html('');
                                });
                            },
                            onError: function(err) {
                                $('#submitButton').prop('disabled', false).html('Submit');
                                show_toastr('Error!', 'Payment failed: ' + err.message, 'danger');
                            },
                            onCancel: function(data) {
                                $('#submitButton').prop('disabled', false).html('Submit');
                                show_toastr('Error!', 'Payment was canceled', 'danger');
                            }
                        }).render('#paypal-button-container');
                    @endif
                @endif
            });
        </script>
    @endif
@endpush
