@extends('layouts.main')
@section('title', __('Create Booking'))
@section('breadcrumb')
    <div class="col-md-12">
        <div class="page-header-title">
            <h4 class="m-b-10">{{ __('Create Booking') }}</h4>
        </div>
        <ul class="breadcrumb">
            <li class="breadcrumb-item">{!! html()->a(route('home'), __('Dashboard')) !!}</li>
            <li class="breadcrumb-item">{!! html()->a(route('bookings.index'), __('Booking')) !!}</li>
            <li class="breadcrumb-item">{{ __('Create Booking') }}</li>
        </ul>
    </div>
@endsection
@section('content')
    <div class="row">
        <div class="section-body">
            <div class="m-auto col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5> {{ __('Create Booking') }}</h5>
                    </div>
                    {!! html()->form('POST', route('bookings.store'))->attribute('enctype', 'multipart/form-data')->attribute('data-validate')->open() !!}
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('Business Name'), 'business_name')->class('form-label') }}
                                    {!! html()->text('business_name', null)->class('form-control')->required()->placeholder(__('Enter business name')) !!}
                                </div>
                                <div class="form-group">
                                    {{ html()->label(__('Business Email'), 'business_email')->class('form-label') }}
                                    {!! html()->text('business_email', null)->class('form-control')->required()->placeholder(__('Enter business email')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('Business Logo'), 'business_logo')->class('form-label') }}
                                    {!! html()->file('business_logo')->class('form-control')->required()->id('business_logo')->accept('.jpeg,.jpg,.png') !!}
                                    <small>{{ __('NOTE: Allowed file extension : .jpeg,.jpg,.png (Max Size: 2 MB)') }}</small>
                                </div>
                                <div class="form-group">
                                    {{ html()->label(__('Business Website URL'), 'business_website')->class('form-label') }}
                                    {!! html()->text('business_website', null)->class('form-control')->required()->placeholder(__('Enter business website url')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('Business Address'), 'business_address')->class('form-label') }}
                                    {!! html()->textarea('business_address', null)->class('form-control')->required()->rows(3)->placeholder(__('Enter business address')) !!}
                                </div>
                                <div class="form-group">
                                    {{ html()->label(__('Business Number'), 'business_number')->class('form-label') }}
                                    {!! html()->number('business_number', null)->class('form-control')->required()->placeholder(__('Enter business number')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {!! html()->label(__('Business Phone'))->for('business_phone')->class('form-label') !!}
                                    {!! html()->input('tel', 'business_phone')->class('form-control')->required()->placeholder(__('Enter business phone'))->name('business_phone')->id('business_phone') !!}
                                </div>
                                <div class="form-group">
                                    {{ html()->label(__('Booking Slots'), 'booking_slots')->class('form-label') }}
                                    {!! html()->select('booking_slots', $bookingSlots, null)->class('form-select')->required()->attribute('data-trigger') !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="mb-3 btn-flt float-end">
                            {!! html()->a(route('bookings.index'), __('Cancel'))->class('btn btn-secondary') !!}
                            {!! html()->button(__('Save'))->type('submit')->class('btn btn-primary') !!}
                        </div>
                    </div>
                    {!! html()->form()->close() !!}
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>
    <script>
        var genericExamples = document.querySelectorAll('[data-trigger]');
        for (i = 0; i < genericExamples.length; ++i) {
            var element = genericExamples[i];
            new Choices(element, {
                placeholderValue: 'This is a placeholder set in the config',
                searchPlaceholderValue: 'This is a search placeholder',
            });
        }
    </script>
@endpush
