@php
    use App\Facades\UtilityFacades;
@endphp
@extends('layouts.form')
@section('title', __('Show Booking'))
@section('content')
    <div class="container">
        <div class="mx-auto mt-5 col-md-7">
            <div class="card" id="printTable">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-md-8 invoice-contact">
                            <div class="invoice-box row">
                                <div class="col-sm-12">
                                    <table class="table mt-0 table-responsive invoice-table table-borderless">
                                        <tbody>
                                            <tr>
                                                <td>{{ $booking->business_name }},<br>{{ $booking->business_address }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ $booking->business_email }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ $booking->business_website }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ $booking->business_number }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ $booking->business_phone }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4"></div>
                    </div>
                    <div class="row invoive-info d-print-inline-flex">
                        <div class="col-sm-8">
                            <h6 class="m-b-20">{{ __('Order Details :') }}</h6>
                            <table class="table mt-0 table-responsive invoice-table invoice-order table-borderless">
                                <tbody>
                                    <tr>
                                        <th>{{ __('Booking Slot Date') }} : </th>
                                        <td class="p-1">{{ UtilityFacades::date_format($bookingValue->booking_slots_date) }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ __('Booking Slots') }} :</th>
                                        <td>{{ $bookingValue->booking_slots }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ __('Status') }} :</th>
                                        <td>
                                            @if ($bookingValue->booking_status == 1)
                                                <span class="badge bg-success">{{ __('Successfully') }}</span>
                                            @elseif($bookingValue->booking_status == 0)
                                                <span class="badge bg-danger">{{ __('Cancel') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-sm-4">
                            @if ($bookingValue->booking_status == 1)
                                {!! html()->form('DELETE', route('appointment.slot.cancel', $bookingValue->id))->class('d-inline')->id('delete-form-' . $bookingValue->id)->open() !!}
                                <a href="javascript:void(0)" class="btn btn-sm small btn-danger show_confirm" data-bs-toggle="tooltip"
                                    data-bs-placement="bottom" id="delete-form-{{ $bookingValue->id }}"
                                    data-bs-original-title="{{ __('Cancel Slots') }}"
                                    aria-label="{{ __('Cancel Slots') }}">{{ __('Cancel Slots') }}</a>
                                {!! html()->form()->close() !!}
                            @endif
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-12">
                            @foreach ($array as $keys => $rows)
                                @foreach ($rows as $row_key => $row)
                                    @if ($row->type == 'checkbox-group')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                <p>
                                                <ul>
                                                    @foreach ($row->values as $key => $options)
                                                        @if (isset($options->selected))
                                                            <li>
                                                                <label>{{ $options->label }}</label>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                                </p>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'file')
                                        <div class="col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                @if (property_exists($row, 'value') && $row->value)
                                                    @php
                                                        $allowedExtensions = ['pdf', 'pdfa', 'fdf', 'xdp', 'xfa', 'pdx', 'pdp', 'pdfxml', 'pdxox', 'xlsx', 'csv', 'xlsm', 'xltx', 'xlsb', 'xltm', 'xlw'];
                                                        $storageType = App\Facades\UtilityFacades::getsettings('storage_type');
                                                        $getFileUrl  = fn($file) => $storageType == 'local' ? asset('storage/app/' . $file) : Storage::url($file);
                                                    @endphp

                                                    <div class="row">
                                                        @if ($row->multiple)
                                                            @foreach ($row->value as $file)
                                                                <div class="col-4">
                                                                    @php
                                                                        $fileName      = basename($file);
                                                                        $fileExtension = pathinfo($file, PATHINFO_EXTENSION);
                                                                    @endphp

                                                                    @if (in_array($fileExtension, $allowedExtensions))
                                                                        <a class="my-2 btn btn-info" href="{{ $getFileUrl($file) }}" type="image" download>
                                                                            {!! Str::limit($fileName, 30, '...') !!}
                                                                        </a>
                                                                    @else
                                                                        <img src="{{ Storage::exists($file) ? $getFileUrl($file) : Storage::url('not-exists-data-images/78x78.png') }}"
                                                                            class="mb-2 img-thumbnailss">
                                                                    @endif
                                                                </div>
                                                            @endforeach
                                                        @else
                                                            <div class="col-4">
                                                                @php
                                                                    if ($row->subtype == 'fineuploader') {
                                                                        $file = $row->value[0] ?? null;
                                                                    } else {
                                                                        $file = $row->value ?? null;
                                                                    }

                                                                    $fileName      = basename($file);
                                                                    $fileExtension = pathinfo($file, PATHINFO_EXTENSION);
                                                                @endphp
                                                                @if ($file)
                                                                    @if (in_array($fileExtension, $allowedExtensions))
                                                                        <a class="my-2 btn btn-info" href="{{ $getFileUrl($file) }}" type="image" download>
                                                                            {!! Str::limit($fileName, 30, '...') !!}
                                                                        </a>
                                                                    @else
                                                                        <img src="{{ Storage::exists($file) ? $getFileUrl($file) : Storage::url('not-exists-data-images/78x78.png') }}"
                                                                            class="mb-2 img-thumbnailss">
                                                                    @endif
                                                                @endif
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @elseif($row->type == 'header')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <{{ $row->subtype }}>
                                                    {!! html_entity_decode($row->label ?? '') !!}
                                                    </{{ $row->subtype }}>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'paragraph')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <{{ $row->subtype }}>
                                                    {!! html_entity_decode($row->label ?? '') !!}
                                                    </{{ $row->subtype }}>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'radio-group')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                <p>
                                                    @foreach ($row->values as $key => $options)
                                                        @if (isset($options->selected))
                                                            {{ $options->label }}
                                                        @endif
                                                    @endforeach
                                                </p>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'select')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                <p>
                                                    @foreach ($row->values as $options)
                                                        @if (isset($options->selected))
                                                            {{ $options->label }}
                                                        @endif
                                                    @endforeach
                                                </p>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'autocomplete')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
						<p>
						    @if (!empty($row->values) && is_array($row->values))
							@foreach ($row->values as $key => $options)
							    @if (isset($options->selected) && $options->selected)
								{{ $options->label }}
							    @endif
							@endforeach
						    @else
							{{ $row->value ?? '' }}
						    @endif
						</p>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'number')
                                        <div class="col-md-6 col-12">
                                            <b>{{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                            </b>
                                            <p>
                                                {{ isset($row->value) ? $row->value : '' }}
                                            </p>
                                        </div>
                                    @elseif($row->type == 'text')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                @if ($row->subtype == 'color')
                                                    <div style="padding: 10px;background-color: {{ $row->value }};">
                                                    </div>
                                                @else
                                                    <p>
                                                        {{ isset($row->value) ? $row->value : '' }}
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    @elseif($row->type == 'date')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                <p>
                                                    {{ isset($row->value) ? date('d-m-Y', strtotime($row->value)) : '' }}
                                                </p>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'textarea')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                @if ($row->subtype == 'ckeditor')
                                                    {!! isset($row->value) ? $row->value : '' !!}
                                                @else
                                                    <p>
                                                        {{ isset($row->value) ? $row->value : '' }}
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    @elseif($row->type == 'starRating')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                @php
                                                    $attr = ['class' => 'form-control'];
                                                    if ($row->required) {
                                                        $attr['required'] = 'required';
                                                    }
                                                    $value = isset($row->value) ? $row->value : 0;
                                                    $no_of_star = isset($row->number_of_star)
                                                        ? $row->number_of_star
                                                        : 5;
                                                @endphp
                                                {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}
                                                @if ($row->required)
                                                    <span class="text-danger align-items-center">*</span>
                                                @endif
                                                <p>
                                                <div id="{{ $row->name ?? '' }}" class="starRating"
                                                    data-value="{{ $value }}"
                                                    data-no_of_star="{{ $no_of_star }}">
                                                </div>
                                                <input type="hidden" name="{{ $row->name ?? '' }}"
                                                    value="{{ $value }}">
                                                </p>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'SignaturePad')
                                        @if (property_exists($row, 'value'))
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <img src="{{ asset(Storage::url($row->value)) }}">
                                                </div>
                                            </div>
                                        @endif
                                    @elseif($row->type == 'break')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <hr style="border: 1px solid #ccc">
                                            </div>
                                        </div>
                                    @elseif($row->type == 'location')
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                {!! html()->label('location_id')->for(__('Location:'))->class('form-label') !!}
                                                <iframe width="100%" height="260" frameborder="0" scrolling="no"
                                                    marginheight="0" marginwidth="0"
                                                    src="https://maps.google.com/maps?q={{ $row->value }}&hl=en&z=14&amp;output=embed">
                                                </iframe>
                                            </div>
                                        </div>
                                    @elseif($row->type == 'video')
                                        @if (isset($row->value) && !empty($row->value) && Storage::exists($row->value))
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                   {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}<br>
                                                    <br>
                                                    <a class="p-2 btn btn-primary"
                                                        href="{{ File::exists(Storage::path($row->value)) ? Storage::url($row->value) : '' }}"
                                                        type="video" download="">{{ __('Download Video') }}</a>
                                                </div>
                                            </div>
                                        @endif
                                    @elseif($row->type == 'selfie')
                                        @if (isset($row->value) && !empty($row->value) && Storage::exists($row->value))
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                   {{ html()->label($row->label ?? '', $row->name ?? '')->class('form-label') }}<br>
                                                    <br>
                                                    <img src="{{ File::exists(Storage::path($row->value)) ? Storage::url($row->value) : Storage::url('app-logo/78x78.png') }}"
                                                        class="mb-2 img-responsive img-thumbnailss" />
                                                    <br>
                                                    <a class="p-2 btn btn-primary" href="{{ Storage::url($row->value) }}"
                                                        type="image" download>{{ __('Download Image') }}</a>
                                                </div>
                                            </div>
                                        @endif
                                    @endif
                                @endforeach
                            @endforeach
                        </div>
                        <div class="col-sm-12">
                            <div class="text-end">
                                <button class="btn btn-primary btn-print-invoice"><i
                                        class="ti ti-printer"></i>{{ __('Print') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('style')
    <link href="{{ asset('vendor/jqueryform/css/jquery.rateyo.min.css') }}" rel="stylesheet" />
@endpush
@push('script')
    <script src="{{ asset('vendor/jqueryform/js/jquery.rateyo.min.js') }}"></script>
    <script>
        document.querySelector('.btn-print-invoice').addEventListener('click', function() {
            var link2 = document.createElement('link');
            link2.innerHTML =
                '<style>@media print{*,::after,::before{text-shadow:none!important;box-shadow:none!important}a:not(.btn){text-decoration:none}abbr[title]::after{content:" ("attr(title) ")"}pre{white-space:pre-wrap!important}blockquote,pre{border:1px solid #adb5bd;page-break-inside:avoid}thead{display:table-header-group}img,tr{page-break-inside:avoid}table,thead,tr,td{background:transparent}h2,h3,p{orphans:3;widows:3}h2,h3{page-break-after:avoid}@page{size:a3}body{min-width:992px!important}.container{min-width:992px!important}.page-header,.pc-sidebar,.pc-mob-header,.pc-header,.pct-customizer,.modal,.navbar{display:none}.pc-container{top:0;}.invoice-contact{padding-top:0;}@page,.card-body,.card-header,body,.pcoded-content{padding:0;margin:0}.badge{border:1px solid #000}.table{border-collapse:collapse!important}.table td,.table th{background-color:#fff!important}.table-bordered td,.table-bordered th{border:1px solid #dee2e6!important}.table-dark{color:inherit}.table-dark tbody+tbody,.table-dark td,.table-dark th,.table-dark thead th{border-color:#dee2e6}.table .thead-dark th{color:inherit;border-color:#dee2e6}}</style>';
            document.getElementsByTagName('head')[0].appendChild(link2);
            window.print();
        });
        var $starRating = $('.starRating');
        if ($starRating.length) {
            $starRating.each(function() {
                var val = $(this).attr('data-value');
                var no_of_star = $(this).attr('data-no_of_star');
                if (no_of_star == 10) {
                    val = val / 2;
                }
                $(this).rateYo({
                    rating: val,
                    readOnly: true,
                    numStars: no_of_star
                })
            });
        }
    </script>
@endpush
