<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('timer_session_breaks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('timer_session_id');
            $table->timestamp('break_start_time');
            $table->timestamp('break_end_time')->nullable();
            $table->timestamps();
            $table->foreign('timer_session_id')->references('id')->on('timer_sessions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('timer_session_breaks');
    }
};
