<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Facades\UtilityFacades;
use Illuminate\Support\Facades\Http;
use Twilio\Rest\Client;

class SmsTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'event',
        'template',
        'variables',
    ];

    public function send($number, $data)
    {
        $message = __($this->template, $data);
        return $this->__sendSMS($number, $message);
    }

    private function __sendSMS($number, $message)
    {
        $provider = UtilityFacades::keysettings('smssetting', 1);
        try {
            if ($provider === 'twilio') {
                $sid   = UtilityFacades::keysettings('twilio_sid', 1);
                $token = UtilityFacades::keysettings('twilio_auth_token', 1);
                $from  = UtilityFacades::keysettings('twilio_number', 1);

                $client = new Client($sid, $token);
                $client->messages->create($number, [
                    'from' => $from,
                    'body' => $message,
                ]);
            } elseif ($provider === 'nexmo') {
                $response = Http::asForm()->post('https://rest.nexmo.com/sms/json/', [
                    'api_key'    => UtilityFacades::keysettings('nexmo_key', 1),
                    'api_secret' => UtilityFacades::keysettings('nexmo_secret', 1),
                    'from'       => env('APP_NAME'),
                    'text'       => $message,
                    'to'         => ltrim($number, '+'),
                ]);

                $result = $response->json();
                if (isset($result['messages'][0]['status']) && $result['messages'][0]['status'] != '0') {
                    return ['is_success' => false, 'message' => $result['messages'][0]['error-text'] ?? 'Nexmo SMS failed'];
                }
            } else {
                return ['is_success' => false, 'message' => 'SMS provider not supported'];
            }

            return ['is_success' => true];
        } catch (\Exception $e) {
            return ['is_success' => false, 'message' => $e->getMessage()];
        }
    }
}
