<?php

namespace App\Mail;

use App\Models\FormValue;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Spatie\MailTemplates\TemplateMailable;

class Thanksmail extends TemplateMailable
{
    public $title;
    public $thanksMsg;
    public $email;
    public $image;

    public function __construct(FormValue $form_value)
    {
        $this->title     = $form_value->Form->title;
        $this->email     = $form_value->Form->email;
        $this->thanksMsg = trim(html_entity_decode(strip_tags($form_value->Form->thanks_msg)));
        $this->image     = Storage::url(!empty($form_value->Form->logo) && File::exists(Storage::path($form_value->Form->logo)) ? $form_value->Form->logo : 'not-exists-data-images/78x78.png');
    }

    public function getHtmlLayout(): string
    {
        return view('emails.layout')->render();
    }
}
