<?php

namespace App\Mail;

use App\Models\BookingValue;
use Hashids\Hashids;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Spatie\MailTemplates\TemplateMailable;

class BookingThanksmail extends TemplateMailable
{
    public $title;
    public $thanksMsg;
    public $image;
    public $link;

    public function __construct(BookingValue $bookingValue)
    {
        $this->title = $bookingValue->Booking->business_name;
        $this->image = Storage::url(
            !empty($bookingValue->Booking->business_logo) && File::exists(Storage::path($bookingValue->Booking->business_logo)) ? $bookingValue->Booking->business_logo : 'not-exists-data-images/78x78.png'
        );
        $this->thanksMsg  = strip_tags('Your booking is successfully completed!');
        $hashids          = new Hashids('', 20);
        $id               = $hashids->encodeHex($bookingValue->id);
        $route            = route('appointment.edit', $id);
        $this->link       = $route;
    }

    public function getHtmlLayout(): string
    {
        return view('emails.layout')->render();
    }
}
