<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Models\FormValue;
use Hashids\Hashids;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Paytm\JsCheckout\Facades\Paytm;

class PaytmController extends Controller
{
    public function paytmPayment(Request $request)
    {
        $mobileNumber = $request->fill_type === 'fill' && Auth::check() ? '+' . ltrim(Auth::user()->country_code ?? '91', '+') . (Auth::user()->phone ?? '1234567890') : '1234567890';
        $payment = Paytm::with('receive');
        $payment->prepare([
            'order'         => rand(),
            'user'          => $request->name,
            'mobile_number' => $mobileNumber,
            'email'         => $request->email,
            'amount'        => $request->amount,
            'submit_type'   => $request->fill_type,
            'callback_url'  => route('paytm.callback', ['form_id' => $request->form_id]),
        ]);
        $response = $payment->receive();
        return $response;
    }

    public function paytmCallback(Request $request)
    {
        $paytmParams = $request->all();
        $form      = Form::find($request->form_id);
        $formvalue = FormValue::where('form_id', $request->form_id)->where('payment_type', 'Paytm')->where('status', 'pending')->latest('id')->first();
        if (!$form || !$formvalue) {
            return redirect()->back()->with('failed', 'Form not found.');
        }
        $status = $request->get('STATUS');
        $formvalue->status = $status === 'TXN_SUCCESS' ? 'successfull' : 'failed';
        $formvalue->transaction_id = $paytmParams['TXNID'] ?? null;
        $formvalue->save();

        $id = (new Hashids('', 20))->encodeHex($form->id);
        $redirectRoute = $request->submit_type === 'public_fill' ? redirect()->route('forms.survey', $id) : redirect()->back();
        if (isset($paytmParams['STATUS']) && $paytmParams['STATUS'] === 'TXN_SUCCESS') {
            return $redirectRoute->with('success', strip_tags(trim($form->success_msg) ?: __('Form submitted successfully.')));
        } else {
            return $redirectRoute->with('failed', $paytmParams['RESPMSG'] ?? __('Payment failed.'));
        }
    }
}
