<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Facades\UtilityFacades;
use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Models\FormValue;
use App\Models\User;
use Hashids\Hashids;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;

class PayUMoneyController extends Controller
{
    public function payumoneyfillPaymentPrepare(Request $request)
    {
        $authuser               = User::find($request->payumoney_created_by);
        $form                   = Form::find($request->payumoney_form_id);
        $price                  = $request->payumoney_amount;
        $currency               = $request->payumoney_currency;
        $symbol                 = $form->currency_symbol;
        $resData['form_id']     = $form->id;
        $resData['email']       = $authuser->email;
        $resData['total_price'] = $price;
        $key                    = UtilityFacades::getsettings('payumoney_merchant_key');
        $txnid                  = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        $salt                   = UtilityFacades::getsettings('payumoney_salt_key');
        $amount                 = $price;
        $productinfo            = $form->title;
        $firstname              = $authuser->name;
        $email                  = $authuser->email;
        $udfs = array_fill(0, 5, '');
        $hashString = implode('|', array_merge(
            [$key, $txnid, $amount, $productinfo, $firstname, $email],
            $udfs,
            array_fill(0, 5, ''),
            [$salt]
        ));

        $hash        = strtolower(hash('sha512', $hashString));
        $phoneNumber = $request->payumoney_submit_type === 'fill' && Auth::check() ? ltrim(Auth::user()->phone ?? '1234567890', '+') : '1234567890';

        $paymentData = [
            'form_id'      => $form->id,
            'key'          => $key,
            'productinfo'  => $productinfo,
            'firstname'    => $firstname,
            'email'        => $email,
            'phone'        => $phoneNumber,
            'amount'       => $amount,
            'txnid'        => $txnid,
            'user_id'      => $authuser->id,
            'currency'     => $currency,
            'payment_type' => 'payumoney',
            'submit_type'  => $request->payumoney_submit_type ?? 'public_fill'
        ];

        $successData = array_merge($paymentData, ['status' => 'pending']);
        $failureData = array_merge($paymentData, ['status' => 'failed']);
        $payuUrl     = 'https://test.payu.in/_payment';
        $paymentData = [
            'key'         => $key,
            'txnid'       => $txnid,
            'amount'      => $resData['total_price'],
            'productinfo' => $form->title,
            'firstname'   => $authuser->name,
            'email'       => $authuser->email,
            'phone'       => $phoneNumber,
            'hash'        => $hash,
            'surl'        => route('payumoneyfillcallback', ['data' => Crypt::encrypt($successData)]),
            'furl'        => route('payumoneyfillcallback', ['data' => Crypt::encrypt($failureData)]),
        ];
        return view('form.payumoneyRedirect', compact('payuUrl', 'paymentData'));
    }

    public function payumoneyfillPlanGetPayment(Request $request)
    {
        $data                       = Crypt::decrypt($request->data ?? '');
        $form                       = Form::find($data['form_id']);
        $formvalue                  = FormValue::where('form_id', $form->id)->latest('id')->first();
        $formvalue->amount          = $request->amount ?? $form->amount ?? $data['amount'] ?? null;
        $formvalue->currency_symbol = $form->currency_symbol ?? null;
        $formvalue->currency_name   = $form->currency_name ?? $data['currency'] ?? null;
        $formvalue->transaction_id  = $request->mihpayid ?? $request->txnid ?? $data['txnid'] ?? null;
        $formvalue->status          = $request->status == 'success' ? 'successfull' : 'failed';
        $formvalue->payment_type    = 'payumoney';
        $formvalue->save();

        $id = (new Hashids('', 20))->encodeHex($form->id);
        $redirectRoute = $data['submit_type'] === 'public_fill' ? redirect()->route('forms.survey', $id) : redirect()->back();
        if (isset($request->status) && $request->status === 'failure') {
            return $redirectRoute->with('failed', $request->error_Message ?? __('Payment failed.'));
        } else {
            return $redirectRoute->with('success', strip_tags(trim($form->success_msg) ?: __('Form submitted successfully.')));
        }
    }
}
