<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Facades\UtilityFacades;
use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Models\FormValue;
use App\Models\User;
use Hashids\Hashids;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Session;

class MollieController extends Controller
{
    public function molliefillPaymentPrepare(Request $request)
    {
        $authuser               = User::find($request->mollie_created_by);
        $form                   = Form::find($request->mollie_form_id);
        $price                  = $request->mollie_amount;
        $currency               = $request->mollie_currency;
        $resData['form_id']     = $form->id;
        $resData['email']       = $authuser->email;
        $resData['total_price'] = $price;
        $encryptedData = Crypt::encrypt([
            'form_id'      => $form->id,
            'user_id'      => $authuser->id,
            'amount'       => $price,
            'currency'     => $currency,
            'payment_type' => 'mollie',
            'status'       => 'pending',
            'submit_type'  => $request->mollie_submit_type ?? 'public_fill',
        ]);
        $mollie                 = new \Mollie\Api\MollieApiClient();
        $mollie->setApiKey(UtilityFacades::getsettings('mollie_api_key'));

        $payment = $mollie->payments->create(
            [
                "amount" => [
                    "currency" => $currency,
                    "value" => number_format((float)$price, 2, '.', ''),
                ],
                "description" =>  "Payment for form: " . $form->name,
                "redirectUrl" => route('molliefillcallback'),
                "metadata" => [
                    "form_id" => $form->id,
                    "user_id" => $authuser->id,
                ],
            ]
        );
        $realRedirectUrl = route('molliefillcallback', [
            'data'       => $encryptedData,
            'payment_id' => $payment->id,
        ]);

        $mollie->payments->update($payment->id, [
            'redirectUrl' => $realRedirectUrl,
        ]);

        return redirect($payment->getCheckoutUrl());
    }

    public function molliefillPlanGetPayment(Request $request)
    {
        $data      = Crypt::decrypt($request->data ?? '');
        $form      = Form::find($data['form_id']);
        $paymentId = $request->payment_id ?? null;
        if (!$paymentId) {
            return redirect()->back()->with('failed', 'Payment failed please try again.');
        }
        $mollie       = new \Mollie\Api\MollieApiClient();
        $mollie->setApiKey(UtilityFacades::getsettings('mollie_api_key'));
        $payment   = $mollie->payments->get($paymentId);
        $formvalue = FormValue::where('form_id', $form->id)->latest('id')->first();
        if (!$formvalue) {
            return redirect()->back()->with('failed', 'Form submission not found');
        }
        $formvalue->amount          = $payment->amount->value ?? $data['amount'] ?? null;
        $formvalue->currency_symbol = $form->currency_symbol ?? null;
        $formvalue->currency_name   = $payment->amount->currency ?? $form->currency_name ?? $data['currency'] ?? null;
        $formvalue->transaction_id  = $payment->id ?? null;
        $formvalue->status          = $payment->status == 'paid' ? 'successfull' : 'failed';
        $formvalue->payment_type    = 'mollie';
        $formvalue->save();
        $id = (new Hashids('', 20))->encodeHex($form->id);
        $redirectRoute = $data['submit_type'] === 'public_fill' ? redirect()->route('forms.survey', $id) : redirect()->back();
        if (isset($payment->status) && $payment->status !== 'paid') {
            return $redirectRoute->with('failed', $payment->details->failureReason ?? $payment->details->failureMessage ?? __('Payment failed.'));
        } else {
            return $redirectRoute->with('success', strip_tags(trim($form->success_msg) ?: __('Form submitted successfully.')));
        }
    }
}
