<?php

namespace App\Http\Controllers\PaymentGateway;

use Illuminate\Http\Request;
use App\Facades\UtilityFacades;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Crypt;
use App\Models\Form;
use App\Models\FormValue;
use Hashids\Hashids;
use MercadoPago\Client\Preference\PreferenceClient;
use MercadoPago\MercadoPagoConfig;

class MercadoController extends Controller
{
    public function mercadofillPaymentPrepare(Request $request)
    {
        try {
            $mercadoMode        = UtilityFacades::keysettings('mercado_mode', $request->mercado_created_by);
            $mercadoAccessToken = UtilityFacades::keysettings('mercado_access_token', $request->mercado_created_by);
            $form               = Form::find($request->mercado_form_id);
            MercadoPagoConfig::setAccessToken($mercadoAccessToken);
            $client = new PreferenceClient();
            $preferenceData = [
                "items" => [
                    [
                        "title" => $form->title,
                        "quantity" => 1,
                        "unit_price" => (float) $request->mercado_amount,
                        "currency_id" => $form->currency_name ?? 'USD',
                    ]
                ],
                "back_urls" => [
                    "success" => route('mercadofillcallback', [
                        Crypt::encrypt([
                            'form_id' => $form->id,
                            'flag' => 'success',
                            'submit_type' => $request->mercado_submit_type
                        ])
                    ]),
                    "failure" => route('mercadofillcallback', [
                        Crypt::encrypt([
                            'form_id' => $form->id,
                            'flag' => 'failure',
                            'submit_type' => $request->mercado_submit_type
                        ])
                    ]),
                    "pending" => route('mercadofillcallback', [
                        Crypt::encrypt([
                            'form_id' => $form->id,
                            'flag' => 'pending',
                            'submit_type' => $request->mercado_submit_type
                        ])
                    ]),
                ],
                "auto_return" => "approved",
            ];
            $preference = $client->create($preferenceData);

            if ($mercadoMode == 'live') {
                $redirectUrl = $preference->init_point;
            } else {
                $redirectUrl = $preference->sandbox_init_point;
            }
            return redirect($redirectUrl);

        } catch (Exception $e) {
            return redirect()->back()->with('failed', __('Payment failed: ' . $e->getMessage()));
        }
    }

    public function mercadofillPlanGetPayment(Request $request, $data)
    {
        $data = Crypt::decrypt($data);
        $form = Form::find($data['form_id']);
        if ($data['flag'] == 'success') {
            $formvalue = FormValue::where('form_id', $form->id)->latest('id')->first();
            $formvalue->currency_symbol = $form->currency_symbol;
            $formvalue->currency_name = $form->currency_name;
            $formvalue->amount = $form->amount;
            $formvalue->transaction_id = $request->payment_id;
            $formvalue->status = 'successfull';
            $formvalue->payment_type = 'Mercado';
        } else {
            $formvalue = FormValue::where('form_id', $form->id)->latest('id')->first();
            $formvalue->currency_symbol = $form->currency_symbol;
            $formvalue->currency_name = $form->currency_name;
            $formvalue->amount = $form->amount;
            $formvalue->status = 'failed';
            $formvalue->payment_type = 'Mercado';
        }
        $formvalue->save();
        $hashids = new Hashids('', 20);
        $id = $hashids->encodeHex($form->id);
        $successMsg = strip_tags($form->success_msg);
        if ($data['submit_type'] == 'public_fill') {
            return redirect()->route('forms.survey', $id)->with('success', $successMsg);
        } else {
            return redirect()->back()->with('success', $successMsg);
        }
    }
}
