<?php

namespace App\Core;

use function PHPSTORM_META\map;

class Data {
    public static function getCountriesList() {
        return array(
            'AF' => array('name' => 'Afghanistan', 'flag' => 'media/flags/afghanistan.svg','phone_code'=>'93'),
            'AX' => array('name' => 'Aland Islands', 'flag' => 'media/flags/aland-islands.svg','phone_code'=>'358'),
            'AL' => array('name' => 'Albania', 'flag' => 'media/flags/albania.svg','phone_code'=>'355'),
            'DZ' => array('name' => 'Algeria', 'flag' => 'media/flags/algeria.svg','phone_code'=>'213'),
            'AS' => array('name' => 'American Samoa', 'flag' => 'media/flags/american-samoa.svg','phone_code'=>'1'),
            'AD' => array('name' => 'Andorra', 'flag' => 'media/flags/andorra.svg','phone_code'=>'376'),
            'AO' => array('name' => 'Angola', 'flag' => 'media/flags/angola.svg','phone_code'=>'244'),
            'AI' => array('name' => 'Anguilla', 'flag' => 'media/flags/anguilla.svg','phone_code'=>'1'),
            'AG' => array('name' => 'Antigua and Barbuda', 'flag' => 'media/flags/antigua-and-barbuda.svg','phone_code'=>'1'),
            'AR' => array('name' => 'Argentina', 'flag' => 'media/flags/argentina.svg','phone_code'=>'54'),
            'AM' => array('name' => 'Armenia', 'flag' => 'media/flags/armenia.svg','phone_code'=>'374'),
            'AW' => array('name' => 'Aruba', 'flag' => 'media/flags/aruba.svg','phone_code'=>'297'),
            'AU' => array('name' => 'Australia', 'flag' => 'media/flags/australia.svg','phone_code'=>'61'),
            'AT' => array('name' => 'Austria', 'flag' => 'media/flags/austria.svg','phone_code'=>'43'),
            'AZ' => array('name' => 'Azerbaijan', 'flag' => 'media/flags/azerbaijan.svg','phone_code'=>'994'),
            'BS' => array('name' => 'Bahamas', 'flag' => 'media/flags/bahamas.svg','phone_code'=>'1'),
            'BH' => array('name' => 'Bahrain', 'flag' => 'media/flags/bahrain.svg','phone_code'=>'973'),
            'BD' => array('name' => 'Bangladesh', 'flag' => 'media/flags/bangladesh.svg','phone_code'=>'880'),
            'BB' => array('name' => 'Barbados', 'flag' => 'media/flags/barbados.svg','phone_code'=>'1'),
            'BY' => array('name' => 'Belarus', 'flag' => 'media/flags/belarus.svg','phone_code'=>'375'),
            'BE' => array('name' => 'Belgium', 'flag' => 'media/flags/belgium.svg','phone_code'=>'32'),
            'BZ' => array('name' => 'Belize', 'flag' => 'media/flags/belize.svg','phone_code'=>'501'),
            'BJ' => array('name' => 'Benin', 'flag' => 'media/flags/benin.svg','phone_code'=>'229'),
            'BM' => array('name' => 'Bermuda', 'flag' => 'media/flags/bermuda.svg','phone_code'=>'1'),
            'BT' => array('name' => 'Bhutan', 'flag' => 'media/flags/bhutan.svg','phone_code'=>'975'),
            'BO' => array('name' => 'Bolivia, Plurinational State of', 'flag' => 'media/flags/bolivia.svg','phone_code'=>'591'),
            'BQ' => array('name' => 'Bonaire, Sint Eustatius and Saba', 'flag' => 'media/flags/bonaire.svg','phone_code'=>'599'),
            'BA' => array('name' => 'Bosnia and Herzegovina', 'flag' => 'media/flags/bosnia-and-herzegovina.svg','phone_code'=>'387'),
            'BW' => array('name' => 'Botswana', 'flag' => 'media/flags/botswana.svg','phone_code'=>'267'),
            'BR' => array('name' => 'Brazil', 'flag' => 'media/flags/brazil.svg','phone_code'=>'55'),
            'IO' => array('name' => 'British Indian Ocean Territory', 'flag' => 'media/flags/british-indian-ocean-territory.svg','phone_code'=>'246'),
            'BN' => array('name' => 'Brunei Darussalam', 'flag' => 'media/flags/brunei.svg','phone_code'=>'673'),
            'BG' => array('name' => 'Bulgaria', 'flag' => 'media/flags/bulgaria.svg','phone_code'=>'359'),
            'BF' => array('name' => 'Burkina Faso', 'flag' => 'media/flags/burkina-faso.svg','phone_code'=>'226'),
            'BI' => array('name' => 'Burundi', 'flag' => 'media/flags/burundi.svg','phone_code'=>'257'),
            'KH' => array('name' => 'Cambodia', 'flag' => 'media/flags/cambodia.svg','phone_code'=>'855'),
            'CM' => array('name' => 'Cameroon', 'flag' => 'media/flags/cameroon.svg','phone_code'=>'237'),
            'CA' => array('name' => 'Canada', 'flag' => 'media/flags/canada.svg','phone_code'=>'1'),
            'CV' => array('name' => 'Cape Verde', 'flag' => 'media/flags/cape-verde.svg','phone_code'=>'238'),
            'KY' => array('name' => 'Cayman Islands', 'flag' => 'media/flags/cayman-islands.svg','phone_code'=>'1'),
            'CF' => array('name' => 'Central African Republic', 'flag' => 'media/flags/central-african-republic.svg','phone_code'=>'236'),
            'TD' => array('name' => 'Chad', 'flag' => 'media/flags/chad.svg','phone_code'=>'235'),
            'CL' => array('name' => 'Chile', 'flag' => 'media/flags/chile.svg','phone_code'=>'56'),
            'CN' => array('name' => 'China', 'flag' => 'media/flags/china.svg','phone_code'=>'86'),
            'CX' => array('name' => 'Christmas Island', 'flag' => 'media/flags/christmas-island.svg','phone_code'=>'61'),
            'CC' => array('name' => 'Cocos (Keeling) Islands', 'flag' => 'media/flags/cocos-island.svg','phone_code'=>'61'),
            'CO' => array('name' => 'Colombia', 'flag' => 'media/flags/colombia.svg','phone_code'=>'57'),
            'KM' => array('name' => 'Comoros', 'flag' => 'media/flags/comoros.svg','phone_code'=>'269'),
            'CK' => array('name' => 'Cook Islands', 'flag' => 'media/flags/cook-islands.svg','phone_code'=>'682'),
            'CR' => array('name' => 'Costa Rica', 'flag' => 'media/flags/costa-rica.svg','phone_code'=>'506'),
            'CI' => array('name' => 'Côte d\'Ivoire', 'flag' => 'media/flags/ivory-coast.svg','phone_code'=>'225'),
            'HR' => array('name' => 'Croatia', 'flag' => 'media/flags/croatia.svg','phone_code'=>'385'),
            'CU' => array('name' => 'Cuba', 'flag' => 'media/flags/cuba.svg','phone_code'=>'53'),
            'CW' => array('name' => 'Curaçao', 'flag' => 'media/flags/curacao.svg','phone_code'=>'599'),
            'CZ' => array('name' => 'Czech Republic', 'flag' => 'media/flags/czech-republic.svg','phone_code'=>'420'),
            'DK' => array('name' => 'Denmark', 'flag' => 'media/flags/denmark.svg','phone_code'=>'45'),
            'DJ' => array('name' => 'Djibouti', 'flag' => 'media/flags/djibouti.svg','phone_code'=>'253'),
            'DM' => array('name' => 'Dominica', 'flag' => 'media/flags/dominica.svg','phone_code'=>'1'),
            'DO' => array('name' => 'Dominican Republic', 'flag' => 'media/flags/dominican-republic.svg','phone_code'=>'1'),
            'EC' => array('name' => 'Ecuador', 'flag' => 'media/flags/ecuador.svg','phone_code'=>'593'),
            'EG' => array('name' => 'Egypt', 'flag' => 'media/flags/egypt.svg','phone_code'=>'20'),
            'SV' => array('name' => 'El Salvador', 'flag' => 'media/flags/el-salvador.svg','phone_code'=>'503'),
            'GQ' => array('name' => 'Equatorial Guinea', 'flag' => 'media/flags/equatorial-guinea.svg','phone_code'=>'240'),
            'ER' => array('name' => 'Eritrea', 'flag' => 'media/flags/eritrea.svg','phone_code'=>'291'),
            'EE' => array('name' => 'Estonia', 'flag' => 'media/flags/estonia.svg','phone_code'=>'372'),
            'ET' => array('name' => 'Ethiopia', 'flag' => 'media/flags/ethiopia.svg','phone_code'=>'251'),
            'FK' => array('name' => 'Falkland Islands (Malvinas)', 'flag' => 'media/flags/falkland-islands.svg','phone_code'=>'500'),
            'FJ' => array('name' => 'Fiji', 'flag' => 'media/flags/fiji.svg','phone_code'=>'679'),
            'FI' => array('name' => 'Finland', 'flag' => 'media/flags/finland.svg','phone_code'=>'358'),
            'FR' => array('name' => 'France', 'flag' => 'media/flags/france.svg','phone_code'=>'33'),
            'PF' => array('name' => 'French Polynesia', 'flag' => 'media/flags/french-polynesia.svg','phone_code'=>'689'),
            'GA' => array('name' => 'Gabon', 'flag' => 'media/flags/gabon.svg','phone_code'=>'241'),
            'GM' => array('name' => 'Gambia', 'flag' => 'media/flags/gambia.svg','phone_code'=>'220'),
            'GE' => array('name' => 'Georgia', 'flag' => 'media/flags/georgia.svg','phone_code'=>'995'),
            'DE' => array('name' => 'Germany', 'flag' => 'media/flags/germany.svg','phone_code'=>'49'),
            'GH' => array('name' => 'Ghana', 'flag' => 'media/flags/ghana.svg','phone_code'=>'233'),
            'GI' => array('name' => 'Gibraltar', 'flag' => 'media/flags/gibraltar.svg','phone_code'=>'350'),
            'GR' => array('name' => 'Greece', 'flag' => 'media/flags/greece.svg','phone_code'=>'30'),
            'GL' => array('name' => 'Greenland', 'flag' => 'media/flags/greenland.svg','phone_code'=>'299'),
            'GD' => array('name' => 'Grenada', 'flag' => 'media/flags/grenada.svg','phone_code'=>'1'),
            'GU' => array('name' => 'Guam', 'flag' => 'media/flags/guam.svg','phone_code'=>'1'),
            'GT' => array('name' => 'Guatemala', 'flag' => 'media/flags/guatemala.svg','phone_code'=>'502'),
            'GG' => array('name' => 'Guernsey', 'flag' => 'media/flags/guernsey.svg','phone_code'=>'44'),
            'GN' => array('name' => 'Guinea', 'flag' => 'media/flags/guinea.svg','phone_code'=>'224'),
            'GW' => array('name' => 'Guinea-Bissau', 'flag' => 'media/flags/guinea-bissau.svg','phone_code'=>'245'),
            'HT' => array('name' => 'Haiti', 'flag' => 'media/flags/haiti.svg','phone_code'=>'509'),
            'VA' => array('name' => 'Holy See (Vatican City State)', 'flag' => 'media/flags/vatican-city.svg','phone_code'=>'379 '),
            'HN' => array('name' => 'Honduras', 'flag' => 'media/flags/honduras.svg','phone_code'=>'504'),
            'HK' => array('name' => 'Hong Kong', 'flag' => 'media/flags/hong-kong.svg','phone_code'=>'852'),
            'HU' => array('name' => 'Hungary', 'flag' => 'media/flags/hungary.svg','phone_code'=>'36'),
            'IS' => array('name' => 'Iceland', 'flag' => 'media/flags/iceland.svg','phone_code'=>'354'),
            'IN' => array('name' => 'India', 'flag' => 'media/flags/india.svg','phone_code'=>'91'),
            'ID' => array('name' => 'Indonesia', 'flag' => 'media/flags/indonesia.svg','phone_code'=>'62'),
            'IR' => array('name' => 'Iran, Islamic Republic of', 'flag' => 'media/flags/iran.svg','phone_code'=>'98'),
            'IQ' => array('name' => 'Iraq', 'flag' => 'media/flags/iraq.svg','phone_code'=>'964'),
            'IE' => array('name' => 'Ireland', 'flag' => 'media/flags/ireland.svg','phone_code'=>'353'),
            'IM' => array('name' => 'Isle of Man', 'flag' => 'media/flags/isle-of-man.svg','phone_code'=>'44'),
            'IL' => array('name' => 'Israel', 'flag' => 'media/flags/israel.svg','phone_code'=>'972'),
            'IT' => array('name' => 'Italy', 'flag' => 'media/flags/italy.svg','phone_code'=>'39'),
            'JM' => array('name' => 'Jamaica', 'flag' => 'media/flags/jamaica.svg','phone_code'=>'1'),
            'JP' => array('name' => 'Japan', 'flag' => 'media/flags/japan.svg','phone_code'=>'81'),
            'JE' => array('name' => 'Jersey', 'flag' => 'media/flags/jersey.svg','phone_code'=>'44'),
            'JO' => array('name' => 'Jordan', 'flag' => 'media/flags/jordan.svg','phone_code'=>'962'),
            'KZ' => array('name' => 'Kazakhstan', 'flag' => 'media/flags/kazakhstan.svg','phone_code'=>'7'),
            'KE' => array('name' => 'Kenya', 'flag' => 'media/flags/kenya.svg','phone_code'=>'254'),
            'KI' => array('name' => 'Kiribati', 'flag' => 'media/flags/kiribati.svg','phone_code'=>'686'),
            'KP' => array('name' => 'Korea, Democratic People\'s Republic of', 'flag' => 'media/flags/north-korea.svg','phone_code'=>'850'),
            'KW' => array('name' => 'Kuwait', 'flag' => 'media/flags/kuwait.svg','phone_code'=>'965'),
            'KG' => array('name' => 'Kyrgyzstan', 'flag' => 'media/flags/kyrgyzstan.svg','phone_code'=>'996'),
            'LA' => array('name' => 'Lao People\'s Democratic Republic', 'flag' => 'media/flags/laos.svg','phone_code'=>'856'),
            'LV' => array('name' => 'Latvia', 'flag' => 'media/flags/latvia.svg','phone_code'=>'371'),
            'LB' => array('name' => 'Lebanon', 'flag' => 'media/flags/lebanon.svg','phone_code'=>'961'),
            'LS' => array('name' => 'Lesotho', 'flag' => 'media/flags/lesotho.svg','phone_code'=>'266'),
            'LR' => array('name' => 'Liberia', 'flag' => 'media/flags/liberia.svg','phone_code'=>'231'),
            'LY' => array('name' => 'Libya', 'flag' => 'media/flags/libya.svg','phone_code'=>'218'),
            'LI' => array('name' => 'Liechtenstein', 'flag' => 'media/flags/liechtenstein.svg','phone_code'=>'423'),
            'LT' => array('name' => 'Lithuania', 'flag' => 'media/flags/lithuania.svg','phone_code'=>'370'),
            'LU' => array('name' => 'Luxembourg', 'flag' => 'media/flags/luxembourg.svg','phone_code'=>'352'),
            'MO' => array('name' => 'Macao', 'flag' => 'media/flags/macao.svg','phone_code'=>'853'),
            'MG' => array('name' => 'Madagascar', 'flag' => 'media/flags/madagascar.svg','phone_code'=>'261'),
            'MW' => array('name' => 'Malawi', 'flag' => 'media/flags/malawi.svg','phone_code'=>'265'),
            'MY' => array('name' => 'Malaysia', 'flag' => 'media/flags/malaysia.svg','phone_code'=>'60'),
            'MV' => array('name' => 'Maldives', 'flag' => 'media/flags/maldives.svg','phone_code'=>'960'),
            'ML' => array('name' => 'Mali', 'flag' => 'media/flags/mali.svg','phone_code'=>'223'),
            'MT' => array('name' => 'Malta', 'flag' => 'media/flags/malta.svg','phone_code'=>'356'),
            'MH' => array('name' => 'Marshall Islands', 'flag' => 'media/flags/marshall-island.svg','phone_code'=>'692'),
            'MQ' => array('name' => 'Martinique', 'flag' => 'media/flags/martinique.svg','phone_code'=>'596'),
            'MR' => array('name' => 'Mauritania', 'flag' => 'media/flags/mauritania.svg','phone_code'=>'222'),
            'MU' => array('name' => 'Mauritius', 'flag' => 'media/flags/mauritius.svg','phone_code'=>'230'),
            'MX' => array('name' => 'Mexico', 'flag' => 'media/flags/mexico.svg','phone_code'=>'52'),
            'FM' => array('name' => 'Micronesia, Federated States of', 'flag' => 'media/flags/micronesia.svg','phone_code'=>'691'),
            'MD' => array('name' => 'Moldova, Republic of', 'flag' => 'media/flags/moldova.svg','phone_code'=>'373'),
            'MC' => array('name' => 'Monaco', 'flag' => 'media/flags/monaco.svg','phone_code'=>'377'),
            'MN' => array('name' => 'Mongolia', 'flag' => 'media/flags/mongolia.svg','phone_code'=>'976'),
            'ME' => array('name' => 'Montenegro', 'flag' => 'media/flags/montenegro.svg','phone_code'=>'382'),
            'MS' => array('name' => 'Montserrat', 'flag' => 'media/flags/montserrat.svg','phone_code'=>'1'),
            'MA' => array('name' => 'Morocco', 'flag' => 'media/flags/morocco.svg','phone_code'=>'212'),
            'MZ' => array('name' => 'Mozambique', 'flag' => 'media/flags/mozambique.svg','phone_code'=>'258'),
            'MM' => array('name' => 'Myanmar', 'flag' => 'media/flags/myanmar.svg','phone_code'=>'95'),
            'NA' => array('name' => 'Namibia', 'flag' => 'media/flags/namibia.svg','phone_code'=>'264'),
            'NR' => array('name' => 'Nauru', 'flag' => 'media/flags/nauru.svg','phone_code'=>'674'),
            'NP' => array('name' => 'Nepal', 'flag' => 'media/flags/nepal.svg','phone_code'=>'977'),
            'NL' => array('name' => 'Netherlands', 'flag' => 'media/flags/netherlands.svg','phone_code'=>'31'),
            'NZ' => array('name' => 'New Zealand', 'flag' => 'media/flags/new-zealand.svg','phone_code'=>'64'),
            'NI' => array('name' => 'Nicaragua', 'flag' => 'media/flags/nicaragua.svg','phone_code'=>'505'),
            'NE' => array('name' => 'Niger', 'flag' => 'media/flags/niger.svg','phone_code'=>'227'),
            'NG' => array('name' => 'Nigeria', 'flag' => 'media/flags/nigeria.svg','phone_code'=>'234'),
            'NU' => array('name' => 'Niue', 'flag' => 'media/flags/niue.svg','phone_code'=>'683'),
            'NF' => array('name' => 'Norfolk Island', 'flag' => 'media/flags/norfolk-island.svg','phone_code'=>'672'),
            'MP' => array('name' => 'Northern Mariana Islands', 'flag' => 'media/flags/northern-mariana-islands.svg','phone_code'=>'1'),
            'NO' => array('name' => 'Norway', 'flag' => 'media/flags/norway.svg','phone_code'=>'47'),
            'OM' => array('name' => 'Oman', 'flag' => 'media/flags/oman.svg','phone_code'=>'968'),
            'PK' => array('name' => 'Pakistan', 'flag' => 'media/flags/pakistan.svg','phone_code'=>'92'),
            'PW' => array('name' => 'Palau', 'flag' => 'media/flags/palau.svg','phone_code'=>'680'),
            'PS' => array('name' => 'Palestinian Territory, Occupied', 'flag' => 'media/flags/palestine.svg','phone_code'=>'970'),
            'PA' => array('name' => 'Panama', 'flag' => 'media/flags/panama.svg','phone_code'=>'507'),
            'PG' => array('name' => 'Papua New Guinea', 'flag' => 'media/flags/papua-new-guinea.svg','phone_code'=>'675'),
            'PY' => array('name' => 'Paraguay', 'flag' => 'media/flags/paraguay.svg','phone_code'=>'595'),
            'PE' => array('name' => 'Peru', 'flag' => 'media/flags/peru.svg','phone_code'=>'51'),
            'PH' => array('name' => 'Philippines', 'flag' => 'media/flags/philippines.svg','phone_code'=>'63'),
            'PL' => array('name' => 'Poland', 'flag' => 'media/flags/poland.svg','phone_code'=>'48'),
            'PT' => array('name' => 'Portugal', 'flag' => 'media/flags/portugal.svg','phone_code'=>'351'),
            'PR' => array('name' => 'Puerto Rico', 'flag' => 'media/flags/puerto-rico.svg','phone_code'=>'1'),
            'QA' => array('name' => 'Qatar', 'flag' => 'media/flags/qatar.svg','phone_code'=>'974'),
            'RO' => array('name' => 'Romania', 'flag' => 'media/flags/romania.svg','phone_code'=>'40'),
            'RU' => array('name' => 'Russian Federation', 'flag' => 'media/flags/russia.svg','phone_code'=>'7'),
            'RW' => array('name' => 'Rwanda', 'flag' => 'media/flags/rwanda.svg','phone_code'=>'250'),
            'BL' => array('name' => 'Saint Barthélemy', 'flag' => 'media/flags/st-barts.svg','phone_code'=>'590'),
            'KN' => array('name' => 'Saint Kitts and Nevis', 'flag' => 'media/flags/saint-kitts-and-nevis.svg','phone_code'=>'1'),
            'LC' => array('name' => 'Saint Lucia', 'flag' => 'media/flags/st-lucia.svg','phone_code'=>'1'),
            'MF' => array('name' => 'Saint Martin (French part)', 'flag' => 'media/flags/sint-maarten.svg','phone_code'=>'590'),
            // 'PM' => array('name' => 'Saint Pierre and Miquelon', 'flag' => 'media/flags/saint-pierre.svg','phone_code'=>'508'),
            'VC' => array('name' => 'Saint Vincent and the Grenadines', 'flag' => 'media/flags/st-vincent-and-the-grenadines.svg','phone_code'=>'1'),
            'WS' => array('name' => 'Samoa', 'flag' => 'media/flags/samoa.svg','phone_code'=>'685'),
            'SM' => array('name' => 'San Marino', 'flag' => 'media/flags/san-marino.svg','phone_code'=>'378'),
            'ST' => array('name' => 'Sao Tome and Principe', 'flag' => 'media/flags/sao-tome-and-prince.svg','phone_code'=>'239'),
            'SA' => array('name' => 'Saudi Arabia', 'flag' => 'media/flags/saudi-arabia.svg','phone_code'=>'966'),
            'SN' => array('name' => 'Senegal', 'flag' => 'media/flags/senegal.svg','phone_code'=>'221'),
            'RS' => array('name' => 'Serbia', 'flag' => 'media/flags/serbia.svg','phone_code'=>'381'),
            'SC' => array('name' => 'Seychelles', 'flag' => 'media/flags/seychelles.svg','phone_code'=>'248'),
            'SL' => array('name' => 'Sierra Leone', 'flag' => 'media/flags/sierra-leone.svg','phone_code'=>'232'),
            'SG' => array('name' => 'Singapore', 'flag' => 'media/flags/singapore.svg','phone_code'=>'65'),
            'SX' => array('name' => 'Sint Maarten (Dutch part)', 'flag' => 'media/flags/sint-maarten.svg','phone_code'=>'721'),
            'SK' => array('name' => 'Slovakia', 'flag' => 'media/flags/slovakia.svg','phone_code'=>'421'),
            'SI' => array('name' => 'Slovenia', 'flag' => 'media/flags/slovenia.svg','phone_code'=>'386'),
            'SB' => array('name' => 'Solomon Islands', 'flag' => 'media/flags/solomon-islands.svg','phone_code'=>'677'),
            'SO' => array('name' => 'Somalia', 'flag' => 'media/flags/somalia.svg','phone_code'=>'252'),
            'ZA' => array('name' => 'South Africa', 'flag' => 'media/flags/south-africa.svg','phone_code'=>'27'),
            'KR' => array('name' => 'South Korea', 'flag' => 'media/flags/south-korea.svg','phone_code'=>'82'),
            'SS' => array('name' => 'South Sudan', 'flag' => 'media/flags/south-sudan.svg','phone_code'=>'211'),
            'ES' => array('name' => 'Spain', 'flag' => 'media/flags/spain.svg','phone_code'=>'34'),
            'LK' => array('name' => 'Sri Lanka', 'flag' => 'media/flags/sri-lanka.svg','phone_code'=>'94'),
            'SD' => array('name' => 'Sudan', 'flag' => 'media/flags/sudan.svg','phone_code'=>'249'),
            'SR' => array('name' => 'Suriname', 'flag' => 'media/flags/suriname.svg','phone_code'=>'597'),
            'SZ' => array('name' => 'Swaziland', 'flag' => 'media/flags/swaziland.svg','phone_code'=>'268'),
            'SE' => array('name' => 'Sweden', 'flag' => 'media/flags/sweden.svg','phone_code'=>'46'),
            'CH' => array('name' => 'Switzerland', 'flag' => 'media/flags/switzerland.svg','phone_code'=>'41'),
            'SY' => array('name' => 'Syrian Arab Republic', 'flag' => 'media/flags/syria.svg','phone_code'=>'963'),
            'TW' => array('name' => 'Taiwan, Province of China', 'flag' => 'media/flags/taiwan.svg','phone_code'=>'886'),
            'TJ' => array('name' => 'Tajikistan', 'flag' => 'media/flags/tajikistan.svg','phone_code'=>'992'),
            'TZ' => array('name' => 'Tanzania, United Republic of', 'flag' => 'media/flags/tanzania.svg','phone_code'=>'255'),
            'TH' => array('name' => 'Thailand', 'flag' => 'media/flags/thailand.svg','phone_code'=>'66'),
            'TG' => array('name' => 'Togo', 'flag' => 'media/flags/togo.svg','phone_code'=>'228'),
            'TK' => array('name' => 'Tokelau', 'flag' => 'media/flags/tokelau.svg','phone_code'=>'690'),
            'TO' => array('name' => 'Tonga', 'flag' => 'media/flags/tonga.svg','phone_code'=>'676'),
            'TT' => array('name' => 'Trinidad and Tobago', 'flag' => 'media/flags/trinidad-and-tobago.svg','phone_code'=>'868'),
            'TN' => array('name' => 'Tunisia', 'flag' => 'media/flags/tunisia.svg','phone_code'=>'216'),
            'TR' => array('name' => 'Turkey', 'flag' => 'media/flags/turkey.svg','phone_code'=>'90'),
            'TM' => array('name' => 'Turkmenistan', 'flag' => 'media/flags/turkmenistan.svg','phone_code'=>'993'),
            'TC' => array('name' => 'Turks and Caicos Islands', 'flag' => 'media/flags/turks-and-caicos.svg','phone_code'=>'1'),
            'TV' => array('name' => 'Tuvalu', 'flag' => 'media/flags/tuvalu.svg','phone_code'=>'688'),
            'UG' => array('name' => 'Uganda', 'flag' => 'media/flags/uganda.svg','phone_code'=>'256'),
            'UA' => array('name' => 'Ukraine', 'flag' => 'media/flags/ukraine.svg','phone_code'=>'380'),
            'AE' => array('name' => 'United Arab Emirates', 'flag' => 'media/flags/united-arab-emirates.svg','phone_code'=>'971'),
            'GB' => array('name' => 'United Kingdom', 'flag' => 'media/flags/united-kingdom.svg','phone_code'=>'44'),
            'US' => array('name' => 'United States', 'flag' => 'media/flags/united-states.svg','phone_code'=>'1'),
            'UY' => array('name' => 'Uruguay', 'flag' => 'media/flags/uruguay.svg','phone_code'=>'598'),
            'UZ' => array('name' => 'Uzbekistan', 'flag' => 'media/flags/uzbekistan.svg','phone_code'=>'998'),
            'VU' => array('name' => 'Vanuatu', 'flag' => 'media/flags/vanuatu.svg','phone_code'=>'678'),
            'VE' => array('name' => 'Venezuela, Bolivarian Republic of', 'flag' => 'media/flags/venezuela.svg','phone_code'=>'58'),
            'VN' => array('name' => 'Vietnam', 'flag' => 'media/flags/vietnam.svg','phone_code'=>'84'),
            'VI' => array('name' => 'Virgin Islands', 'flag' => 'media/flags/virgin-islands.svg','phone_code'=>'1'),
            'YE' => array('name' => 'Yemen', 'flag' => 'media/flags/yemen.svg','phone_code'=>'967'),
            'ZM' => array('name' => 'Zambia', 'flag' => 'media/flags/zambia.svg','phone_code'=>'260'),
            'ZW' => array('name' => 'Zimbabwe', 'flag' => 'media/flags/zimbabwe.svg','phone_code'=>'263')
        );
    }

    public static function getPhoneCodesList(){
        return array(
            '93'=>'93',
            '355'=>'355',
            '213'=>'213',
            '376'=>'376',
            '244'=>'244',
            '54'=>'54',
            '374'=>'374',
            '297'=>'297',
            '43'=>'43',
            '994'=>'994',
            '973'=>'973',
            '880'=>'880',
            '375'=>'375',
            '32'=>'32',
            '501'=>'501',
            '229'=>'229',
            '975'=>'975',
            '591'=>'591',
            '387'=>'387',
            '267'=>'267',
            '55'=>'55',
            '246'=>'246',
            '673'=>'673',
            '359'=>'359',
            '226'=>'226',
            '257'=>'257',
            '855'=>'855',
            '237'=>'237',
            '238'=>'238',
            '236'=>'236',
            '235'=>'235',
            '56'=>'56',
            '86'=>'86',
            '61'=>'61',
            '57'=>'57',
            '269'=>'269',
            '682'=>'682',
            '506'=>'506',
            '225'=>'225',
            '385'=>'385',
            '53'=>'53',
            '599'=>'599',
            '420'=>'420',
            '45'=>'45',
            '253'=>'253',
            '593'=>'593',
            '20'=>'20',
            '503'=>'503',
            '240'=>'240',
            '291'=>'291',
            '372'=>'372',
            '251'=>'251',
            '500'=>'500',
            '679'=>'679',
            '358'=>'358',
            '33'=>'33',
            '689'=>'689',
            '241'=>'241',
            '220'=>'220',
            '995'=>'995',
            '49'=>'49',
            '233'=>'233',
            '350'=>'350',
            '30'=>'30',
            '299'=>'299',
            '502'=>'502',
            '224'=>'224',
            '245'=>'245',
            '509'=>'509',
            '379 '=>'379 ',
            '504'=>'504',
            '852'=>'852',
            '36'=>'36',
            '354'=>'354',
            '91'=>'91',
            '62'=>'62',
            '98'=>'98',
            '964'=>'964',
            '353'=>'353',
            '972'=>'972',
            '39'=>'39',
            '81'=>'81',
            '962'=>'962',
            '254'=>'254',
            '686'=>'686',
            '850'=>'850',
            '965'=>'965',
            '996'=>'996',
            '856'=>'856',
            '371'=>'371',
            '961'=>'961',
            '266'=>'266',
            '231'=>'231',
            '218'=>'218',
            '423'=>'423',
            '370'=>'370',
            '352'=>'352',
            '853'=>'853',
            '261'=>'261',
            '265'=>'265',
            '60'=>'60',
            '960'=>'960',
            '223'=>'223',
            '356'=>'356',
            '692'=>'692',
            '596'=>'596',
            '222'=>'222',
            '230'=>'230',
            '52'=>'52',
            '691'=>'691',
            '373'=>'373',
            '377'=>'377',
            '976'=>'976',
            '382'=>'382',
            '212'=>'212',
            '258'=>'258',
            '95'=>'95',
            '264'=>'264',
            '674'=>'674',
            '977'=>'977',
            '31'=>'31',
            '64'=>'64',
            '505'=>'505',
            '227'=>'227',
            '234'=>'234',
            '683'=>'683',
            '672'=>'672',
            '47'=>'47',
            '968'=>'968',
            '92'=>'92',
            '680'=>'680',
            '970'=>'970',
            '507'=>'507',
            '675'=>'675',
            '595'=>'595',
            '51'=>'51',
            '63'=>'63',
            '48'=>'48',
            '351'=>'351',
            '974'=>'974',
            '40'=>'40',
            '7'=>'7',
            '250'=>'250',
            '685'=>'685',
            '378'=>'378',
            '239'=>'239',
            '966'=>'966',
            '221'=>'221',
            '381'=>'381',
            '248'=>'248',
            '232'=>'232',
            '65'=>'65',
            '721'=>'721',
            '421'=>'421',
            '386'=>'386',
            '677'=>'677',
            '252'=>'252',
            '27'=>'27',
            '82'=>'82',
            '211'=>'211',
            '34'=>'34',
            '94'=>'94',
            '249'=>'249',
            '597'=>'597',
            '268'=>'268',
            '46'=>'46',
            '41'=>'41',
            '963'=>'963',
            '886'=>'886',
            '992'=>'992',
            '255'=>'255',
            '66'=>'66',
            '228'=>'228',
            '690'=>'690',
            '676'=>'676',
            '868'=>'868',
            '216'=>'216',
            '90'=>'90',
            '993'=>'993',
            '688'=>'688',
            '256'=>'256',
            '380'=>'380',
            '971'=>'971',
            '44'=>'44',
            '598'=>'598',
            '998'=>'998',
            '678'=>'678',
            '58'=>'58',
            '84'=>'84',
            '1'=>'1',
            '967'=>'967',
            '260'=>'260',
            '263'=>'263',
        );
    }

    public static function getLanguagesList() {
        $countryArr = Data::getCountriesList();

        return array(
            'id' => array('name' => 'Bahasa Indonesia - Indonesian', 'country' => $countryArr['ID']),
            'msa' => array('name' => 'Bahasa Melayu - Malay', 'country' => $countryArr['MY']),
            'ca' => array('name' => 'Català - Catalan', 'country' => $countryArr['CA']),
            'cs' => array('name' => 'Čeština - Czech', 'country' => $countryArr['CZ']),
            'da' => array('name' => 'Dansk - Danish', 'country' => $countryArr['NL']),
            'de' => array('name' => 'Deutsch - German', 'country' => $countryArr['DE']),
            'en' => array('name' => 'English', 'country' => $countryArr['GB']),
            'en-gb' => array('name' => 'English UK - British English', 'country' => $countryArr['GB']),
            'es' => array('name' => 'Español - Spanish', 'country' => $countryArr['ES']),
            'fil' => array('name' => 'Filipino', 'country' => $countryArr['PH']),
            'fr' => array('name' => 'Français - French', 'country' => $countryArr['FR']),
            'ga' => array('name' => 'Gaeilge - Irish (beta)', 'country' => $countryArr['GA']),
            'gl' => array('name' => 'Galego - Galician (beta)', 'country' => $countryArr['GL']),
            'hr' => array('name' => 'Hrvatski - Croatian', 'country' => $countryArr['HR']),
            'it' => array('name' => 'Italiano - Italian', 'country' => $countryArr['IT']),
            'hu' => array('name' => 'Magyar - Hungarian', 'country' => $countryArr['HU']),
            'nl' => array('name' => 'Nederlands - Dutch', 'country' => $countryArr['NL']),
            'no' => array('name' => 'Norsk - Norwegian', 'country' => $countryArr['NO']),
            'pl' => array('name' => 'Polski - Polish', 'country' => $countryArr['PL']),
            'pt' => array('name' => 'Português - Portuguese', 'country' => $countryArr['PT']),
            'ro' => array('name' => 'Română - Romanian', 'country' => $countryArr['RO']),
            'sk' => array('name' => 'Slovenčina - Slovak', 'country' => $countryArr['SK']),
            'fi' => array('name' => 'Suomi - Finnish', 'country' => $countryArr['FI']),
            'sv' => array('name' => 'Svenska - Swedish', 'country' => $countryArr['SV']),
            'vi' => array('name' => 'Tiếng Việt - Vietnamese', 'country' => $countryArr['VI']),
            'tr' => array('name' => 'Türkçe - Turkish', 'country' => $countryArr['TR']),
            'el' => array('name' => 'Ελληνικά - Greek', 'country' => $countryArr['GR']),
            'bg' => array('name' => 'Български език - Bulgarian', 'country' => $countryArr['BG']),
            'ru' => array('name' => 'Русский - Russian', 'country' => $countryArr['RU']),
            'sr' => array('name' => 'Српски - Serbian', 'country' => $countryArr['SR']),
            'uk' => array('name' => 'Українська мова - Ukrainian', 'country' => $countryArr['UA']),
            'he' => array('name' => 'עִבְרִית - Hebrew', 'country' => $countryArr['IL']),
            'ur' => array('name' => 'اردو - Urdu (beta)', 'country' => $countryArr['PK']),
            'ar' => array('name' => 'العربية - Arabic', 'country' => $countryArr['AR']),
            'fa' => array('name' => 'فارسی - Persian', 'country' => $countryArr['AR']),
            'mr' => array('name' => 'मराठी - Marathi', 'country' => $countryArr['MR']),
            'hi' => array('name' => 'हिन्दी - Hindi', 'country' => $countryArr['IN']),
            'bn' => array('name' => 'বাংলা - Bangla', 'country' => $countryArr['BD']),
            'gu' => array('name' => 'ગુજરાતી - Gujarati', 'country' => $countryArr['GU']),
            'ta' => array('name' => 'தமிழ் - Tamil', 'country' => $countryArr['IN']),
            'kn' => array('name' => 'ಕನ್ನಡ - Kannada', 'country' => $countryArr['KN']),
            'th' => array('name' => 'ภาษาไทย - Thai', 'country' => $countryArr['TH']),
            'ko' => array('name' => '한국어 - Korean', 'country' => $countryArr['KR']),
            'ja' => array('name' => '日本語 - Japanese', 'country' => $countryArr['JP']),
            'zh-cn' => array('name' => '简体中文 - Simplified Chinese', 'country' => $countryArr['CN']),
            'zh-tw' => array('name' => '繁體中文 - Traditional Chinese', 'country' => $countryArr['TW'])
        );
    }

    public static function getCurrencyList() {
        $countryArr = Data::getCountriesList();

        return array(
            'USD' => array('name' => 'USA dollar', 'country' => $countryArr['US']),
            'GBP' => array('name' => 'British pound', 'country' => $countryArr['GB']),
            'AUD' => array('name' => 'Australian dollar', 'country' => $countryArr['AU']),
            'JPY' => array('name' => 'Japanese yen', 'country' => $countryArr['JP']),
            'SEK' => array('name' => 'Swedish krona', 'country' => $countryArr['SE']),
            'CAD' => array('name' => 'Canadian dollar', 'country' => $countryArr['CA']),
            'CHF' => array('name' => 'Swiss franc', 'country' => $countryArr['CH'])
        );
    }

    public static function getTimeZonesList() {
        return array(
            'International Date Line West' => array('name' => '(GMT-11:00) International Date Line West', 'offset' => '-39600'),
            'Midway Island' => array('name' => '(GMT-11:00) Midway Island', 'offset' => '-39600'),
            'Samoa' => array('name' => '(GMT-11:00) Samoa', 'offset' => '-39600'),
            'Hawaii' => array('name' => '(GMT-10:00) Hawaii', 'offset' => '-36000'),
            'Alaska' => array('name' => '(GMT-08:00) Alaska', 'offset' => '-28800'),
            'Pacific Time (US & Canada)' => array('name' => '(GMT-07:00) Pacific Time (US & Canada)', 'offset' => '-25200'),
            'Tijuana' => array('name' => '(GMT-07:00) Tijuana', 'offset' => '-25200'),
            'Arizona' => array('name' => '(GMT-07:00) Arizona', 'offset' => '-25200'),
            'Mountain Time (US & Canada)' => array('name' => '(GMT-06:00) Mountain Time (US & Canada)', 'offset' => '-21600'),
            'Chihuahua' => array('name' => '(GMT-06:00) Chihuahua', 'offset' => '-21600'),
            'Mazatlan' => array('name' => '(GMT-06:00) Mazatlan', 'offset' => '-21600'),
            'Saskatchewan' => array('name' => '(GMT-06:00) Saskatchewan', 'offset' => '-21600'),
            'Central America' => array('name' => '(GMT-06:00) Central America', 'offset' => '-21600'),
            'Central Time (US & Canada)' => array('name' => '(GMT-05:00) Central Time (US & Canada)', 'offset' => '-18000'),
            'Guadalajara' => array('name' => '(GMT-05:00) Guadalajara', 'offset' => '-18000'),
            'Mexico City' => array('name' => '(GMT-05:00) Mexico City', 'offset' => '-18000'),
            'Monterrey' => array('name' => '(GMT-05:00) Monterrey', 'offset' => '-18000'),
            'Bogota' => array('name' => '(GMT-05:00) Bogota', 'offset' => '-18000'),
            'Lima' => array('name' => '(GMT-05:00) Lima', 'offset' => '-18000'),
            'Quito' => array('name' => '(GMT-05:00) Quito', 'offset' => '-18000'),
            'Eastern Time (US & Canada)' => array('name' => '(GMT-04:00) Eastern Time (US & Canada)', 'offset' => '-14400'),
            'Indiana (East)' => array('name' => '(GMT-04:00) Indiana (East)', 'offset' => '-14400'),
            'Caracas' => array('name' => '(GMT-04:00) Caracas', 'offset' => '-14400'),
            'La Paz' => array('name' => '(GMT-04:00) La Paz', 'offset' => '-14400'),
            'Georgetown' => array('name' => '(GMT-04:00) Georgetown', 'offset' => '-14400'),
            'Atlantic Time (Canada)' => array('name' => '(GMT-03:00) Atlantic Time (Canada)', 'offset' => '-10800'),
            'Santiago' => array('name' => '(GMT-03:00) Santiago', 'offset' => '-10800'),
            'Brasilia' => array('name' => '(GMT-03:00) Brasilia', 'offset' => '-10800'),
            'Buenos Aires' => array('name' => '(GMT-03:00) Buenos Aires', 'offset' => '-10800'),
            'Newfoundland' => array('name' => '(GMT-02:30) Newfoundland', 'offset' => '-9000'),
            'Greenland' => array('name' => '(GMT-02:00) Greenland', 'offset' => '-7200'),
            'Mid-Atlantic' => array('name' => '(GMT-02:00) Mid-Atlantic', 'offset' => '-7200'),
            'Cape Verde Is.' => array('name' => '(GMT-01:00) Cape Verde Is.', 'offset' => '-3600'),
            'Azores' => array('name' => '(GMT) Azores', 'offset' => '0'),
            'Monrovia' => array('name' => '(GMT) Monrovia', 'offset' => '0'),
            'UTC' => array('name' => '(GMT) UTC', 'offset' => '0'),
            'Dublin' => array('name' => '(GMT+01:00) Dublin', 'offset' => '3600'),
            'Edinburgh' => array('name' => '(GMT+01:00) Edinburgh', 'offset' => '3600'),
            'Lisbon' => array('name' => '(GMT+01:00) Lisbon', 'offset' => '3600'),
            'London' => array('name' => '(GMT+01:00) London', 'offset' => '3600'),
            'Casablanca' => array('name' => '(GMT+01:00) Casablanca', 'offset' => '3600'),
            'West Central Africa' => array('name' => '(GMT+01:00) West Central Africa', 'offset' => '3600'),
            'Belgrade' => array('name' => '(GMT+02:00) Belgrade', 'offset' => '7200'),
            'Bratislava' => array('name' => '(GMT+02:00) Bratislava', 'offset' => '7200'),
            'Budapest' => array('name' => '(GMT+02:00) Budapest', 'offset' => '7200'),
            'Ljubljana' => array('name' => '(GMT+02:00) Ljubljana', 'offset' => '7200'),
            'Prague' => array('name' => '(GMT+02:00) Prague', 'offset' => '7200'),
            'Sarajevo' => array('name' => '(GMT+02:00) Sarajevo', 'offset' => '7200'),
            'Skopje' => array('name' => '(GMT+02:00) Skopje', 'offset' => '7200'),
            'Warsaw' => array('name' => '(GMT+02:00) Warsaw', 'offset' => '7200'),
            'Zagreb' => array('name' => '(GMT+02:00) Zagreb', 'offset' => '7200'),
            'Brussels' => array('name' => '(GMT+02:00) Brussels', 'offset' => '7200'),
            'Copenhagen' => array('name' => '(GMT+02:00) Copenhagen', 'offset' => '7200'),
            'Madrid' => array('name' => '(GMT+02:00) Madrid', 'offset' => '7200'),
            'Paris' => array('name' => '(GMT+02:00) Paris', 'offset' => '7200'),
            'Amsterdam' => array('name' => '(GMT+02:00) Amsterdam', 'offset' => '7200'),
            'Berlin' => array('name' => '(GMT+02:00) Berlin', 'offset' => '7200'),
            'Bern' => array('name' => '(GMT+02:00) Bern', 'offset' => '7200'),
            'Rome' => array('name' => '(GMT+02:00) Rome', 'offset' => '7200'),
            'Stockholm' => array('name' => '(GMT+02:00) Stockholm', 'offset' => '7200'),
            'Vienna' => array('name' => '(GMT+02:00) Vienna', 'offset' => '7200'),
            'Cairo' => array('name' => '(GMT+02:00) Cairo', 'offset' => '7200'),
            'Harare' => array('name' => '(GMT+02:00) Harare', 'offset' => '7200'),
            'Pretoria' => array('name' => '(GMT+02:00) Pretoria', 'offset' => '7200'),
            'Bucharest' => array('name' => '(GMT+03:00) Bucharest', 'offset' => '10800'),
            'Helsinki' => array('name' => '(GMT+03:00) Helsinki', 'offset' => '10800'),
            'Kiev' => array('name' => '(GMT+03:00) Kiev', 'offset' => '10800'),
            'Kyiv' => array('name' => '(GMT+03:00) Kyiv', 'offset' => '10800'),
            'Riga' => array('name' => '(GMT+03:00) Riga', 'offset' => '10800'),
            'Sofia' => array('name' => '(GMT+03:00) Sofia', 'offset' => '10800'),
            'Tallinn' => array('name' => '(GMT+03:00) Tallinn', 'offset' => '10800'),
            'Vilnius' => array('name' => '(GMT+03:00) Vilnius', 'offset' => '10800'),
            'Athens' => array('name' => '(GMT+03:00) Athens', 'offset' => '10800'),
            'Istanbul' => array('name' => '(GMT+03:00) Istanbul', 'offset' => '10800'),
            'Minsk' => array('name' => '(GMT+03:00) Minsk', 'offset' => '10800'),
            'Jerusalem' => array('name' => '(GMT+03:00) Jerusalem', 'offset' => '10800'),
            'Moscow' => array('name' => '(GMT+03:00) Moscow', 'offset' => '10800'),
            'St. Petersburg' => array('name' => '(GMT+03:00) St. Petersburg', 'offset' => '10800'),
            'Volgograd' => array('name' => '(GMT+03:00) Volgograd', 'offset' => '10800'),
            'Kuwait' => array('name' => '(GMT+03:00) Kuwait', 'offset' => '10800'),
            'Riyadh' => array('name' => '(GMT+03:00) Riyadh', 'offset' => '10800'),
            'Nairobi' => array('name' => '(GMT+03:00) Nairobi', 'offset' => '10800'),
            'Baghdad' => array('name' => '(GMT+03:00) Baghdad', 'offset' => '10800'),
            'Abu Dhabi' => array('name' => '(GMT+04:00) Abu Dhabi', 'offset' => '14400'),
            'Muscat' => array('name' => '(GMT+04:00) Muscat', 'offset' => '14400'),
            'Baku' => array('name' => '(GMT+04:00) Baku', 'offset' => '14400'),
            'Tbilisi' => array('name' => '(GMT+04:00) Tbilisi', 'offset' => '14400'),
            'Yerevan' => array('name' => '(GMT+04:00) Yerevan', 'offset' => '14400'),
            'Tehran' => array('name' => '(GMT+04:30) Tehran', 'offset' => '16200'),
            'Kabul' => array('name' => '(GMT+04:30) Kabul', 'offset' => '16200'),
            'Ekaterinburg' => array('name' => '(GMT+05:00) Ekaterinburg', 'offset' => '18000'),
            'Islamabad' => array('name' => '(GMT+05:00) Islamabad', 'offset' => '18000'),
            'Karachi' => array('name' => '(GMT+05:00) Karachi', 'offset' => '18000'),
            'Tashkent' => array('name' => '(GMT+05:00) Tashkent', 'offset' => '18000'),
            'Chennai' => array('name' => '(GMT+05:30) Chennai', 'offset' => '19800'),
            'Kolkata' => array('name' => '(GMT+05:30) Kolkata', 'offset' => '19800'),
            'Mumbai' => array('name' => '(GMT+05:30) Mumbai', 'offset' => '19800'),
            'New Delhi' => array('name' => '(GMT+05:30) New Delhi', 'offset' => '19800'),
            'Sri Jayawardenepura' => array('name' => '(GMT+05:30) Sri Jayawardenepura', 'offset' => '19800'),
            'Kathmandu' => array('name' => '(GMT+05:45) Kathmandu', 'offset' => '20700'),
            'Astana' => array('name' => '(GMT+06:00) Astana', 'offset' => '21600'),
            'Dhaka' => array('name' => '(GMT+06:00) Dhaka', 'offset' => '21600'),
            'Almaty' => array('name' => '(GMT+06:00) Almaty', 'offset' => '21600'),
            'Urumqi' => array('name' => '(GMT+06:00) Urumqi', 'offset' => '21600'),
            'Rangoon' => array('name' => '(GMT+06:30) Rangoon', 'offset' => '23400'),
            'Novosibirsk' => array('name' => '(GMT+07:00) Novosibirsk', 'offset' => '25200'),
            'Bangkok' => array('name' => '(GMT+07:00) Bangkok', 'offset' => '25200'),
            'Hanoi' => array('name' => '(GMT+07:00) Hanoi', 'offset' => '25200'),
            'Jakarta' => array('name' => '(GMT+07:00) Jakarta', 'offset' => '25200'),
            'Krasnoyarsk' => array('name' => '(GMT+07:00) Krasnoyarsk', 'offset' => '25200'),
            'Beijing' => array('name' => '(GMT+08:00) Beijing', 'offset' => '28800'),
            'Chongqing' => array('name' => '(GMT+08:00) Chongqing', 'offset' => '28800'),
            'Hong Kong' => array('name' => '(GMT+08:00) Hong Kong', 'offset' => '28800'),
            'Kuala Lumpur' => array('name' => '(GMT+08:00) Kuala Lumpur', 'offset' => '28800'),
            'Singapore' => array('name' => '(GMT+08:00) Singapore', 'offset' => '28800'),
            'Taipei' => array('name' => '(GMT+08:00) Taipei', 'offset' => '28800'),
            'Perth' => array('name' => '(GMT+08:00) Perth', 'offset' => '28800'),
            'Irkutsk' => array('name' => '(GMT+08:00) Irkutsk', 'offset' => '28800'),
            'Ulaan Bataar' => array('name' => '(GMT+08:00) Ulaan Bataar', 'offset' => '28800'),
            'Seoul' => array('name' => '(GMT+09:00) Seoul', 'offset' => '32400'),
            'Osaka' => array('name' => '(GMT+09:00) Osaka', 'offset' => '32400'),
            'Sapporo' => array('name' => '(GMT+09:00) Sapporo', 'offset' => '32400'),
            'Tokyo' => array('name' => '(GMT+09:00) Tokyo', 'offset' => '32400'),
            'Yakutsk' => array('name' => '(GMT+09:00) Yakutsk', 'offset' => '32400'),
            'Darwin' => array('name' => '(GMT+09:30) Darwin', 'offset' => '34200'),
            'Adelaide' => array('name' => '(GMT+09:30) Adelaide', 'offset' => '34200'),
            'Canberra' => array('name' => '(GMT+10:00) Canberra', 'offset' => '36000'),
            'Melbourne' => array('name' => '(GMT+10:00) Melbourne', 'offset' => '36000'),
            'Sydney' => array('name' => '(GMT+10:00) Sydney', 'offset' => '36000'),
            'Brisbane' => array('name' => '(GMT+10:00) Brisbane', 'offset' => '36000'),
            'Hobart' => array('name' => '(GMT+10:00) Hobart', 'offset' => '36000'),
            'Vladivostok' => array('name' => '(GMT+10:00) Vladivostok', 'offset' => '36000'),
            'Guam' => array('name' => '(GMT+10:00) Guam', 'offset' => '36000'),
            'Port Moresby' => array('name' => '(GMT+10:00) Port Moresby', 'offset' => '36000'),
            'Solomon Is.' => array('name' => '(GMT+10:00) Solomon Is.', 'offset' => '36000'),
            'Magadan' => array('name' => '(GMT+11:00) Magadan', 'offset' => '39600'),
            'New Caledonia' => array('name' => '(GMT+11:00) New Caledonia', 'offset' => '39600'),
            'Fiji' => array('name' => '(GMT+12:00) Fiji', 'offset' => '43200'),
            'Kamchatka' => array('name' => '(GMT+12:00) Kamchatka', 'offset' => '43200'),
            'Marshall Is.' => array('name' => '(GMT+12:00) Marshall Is.', 'offset' => '43200'),
            'Auckland' => array('name' => '(GMT+12:00) Auckland', 'offset' => '43200'),
            'Wellington' => array('name' => '(GMT+12:00) Wellington', 'offset' => '43200'),
            'Nuku\'alofa' => array('name' => '(GMT+13:00) Nuku\'alofa', 'offset' => '46800')
        );
    }
}
